/*
 * programs/wsetbg.c, part of W
 * (C) 94-02/96 by Torsten Scherer (TeSche)
 * itschere@techfak.uni-bielefeld.de
 *
 * changed for W1R2 by TeSche 01-11/95
 * w_readimg() moved into Wlib, TeSche 01/96
 *
 * changes 11/97:
 * As 'wbm' is now the preferred method for image output, I decided to
 * convert this into a utility with which one can set the W background
 * pattern or (in future) color.	++eero
 */

#include <stdio.h>
#include <stdlib.h>
#include <Wlib.h>


/*
 * guess what...
 */

int main(long argc, char *argv[])
{
	ushort patt = W_PATTERN;
	WSERVER *wserver;

	if (argc > 2 || (argc == 2 && (argv[1][0] < '0' || argv[1][0] > '9'))) {
		fprintf(stderr, "usage: wsetbg [pattern id]\n");
		return -1;
	}

	if (argc == 2) {
		patt = atoi(argv[1]);
	}

	if (!(wserver = w_init())) {
		fprintf(stderr, "error: can't connect to W server\n");
		return -1;
	}

	w_setmode(WROOT, M_DRAW);
	w_setpattern(WROOT, patt);
	w_dpbox(WROOT, 0, 0, wserver->width, wserver->height);
	w_flush();

	return 0;
}
