/*
 * programs/cpyrgt.c, part of W
 * (C) 94-07/96 by Torsten Scherer (TeSche)
 * itschere@techfak.uni-bielfeld.de
 *
 * Changes:
 * - Uses my new bitmap functions and can be quit with a mouse click
 *   or keypress (after a while this notice comes a bit too familiar).
 * - calculates string position so you can change bitmap and fonts.
 *   ++eero
 */

#include <stdio.h>
#include <string.h>
#include <Wlib.h>

/* so that it will fit even on the smallest screen... */
#define WIDTH 312
#define HEIGHT 192

#define Center(fn,s)	((WIDTH - w_strlen(fn,s)) / 2)

/*
 * a picture...
 */

static char *pic[] = {
  "72 72 2 1",
  "  c #000000",
  "# c #ffffff",
  "##########   #   #   #####################           #    ##############",
  "#######     # # # # ##    ############    # # # # # # # # # #   ########",
  "#####          #       #    #######            #       #         #######",
  "####    # # # # # # # # # # ###   # # # # # # # # # # # # # # #   ######",
  "###      # # #   # # #   #       #   #   #   #   # # ##  #   #     #####",
  "##    # # # # # # # # # # # # # # # # # # # # # # # # # # # # # #   ####",
  "##     #   #   # # #   #   #       #   #   #   # # #   #   #   #     ###",
  "#   # # # # # # # # ##  # # # # # # # # # # # # # # ### # # # # # #  ###",
  "#    # # # # # # # # #   #   # # # # # # # # # # # # # # # # # # #   ###",
  "# # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # #  ###",
  "       #           #   #   #         # # # # # # #         # # #     ###",
  "  # # #           # # # # #           # ### ### #           ### # #  ###",
  "   # #             # # # # #           # # # # # #           # # #    ##",
  "  # # #           ### # # #            ## ### ### #           # # #   ##",
  "   # #             #   # # #           # # # # #   #         # # #   ###",
  "  # ###           ##### ### #          ########## # #        ## #   ####",
  " # # # #           ### # # #           # # ### # # # #       # #   # ###",
  "  # # ###         ####### ###          ########## # #        #### # ####",
  "   # # # #         # # # # # #         # # # ### # #         # # # #####",
  "  # ### ##          ######### #        ############ # #      ## #   ####",
  " # # # # #         ### # # # #          ## ### # # # #       # # #  ####",
  "  # # ##            ######### ##        ######### # # #      ## #   ####",
  "   # #   #         ### # # # # #         ### ### # #           #    ####",
  "  # ### # #         ###########         #########     #      ## #    ###",
  " # # #   #         # ##### # # #         ###         #       # # #   ###",
  "  # ##  # ##        ########### #               # # # #       ###    ###",
  "   # # #   #         ### ##### #     #         #   #   #     # # #   ###",
  "  # # # # ##        ########### # #     # # # # # # # #      ## #    ###",
  " # #     # #         ######### #         # # # # # # #       # # #   ###",
  "  ### # # ##          ########            # # # # # # #       ###    ###",
  "   #   # # #         ######                # # # # # # #     # # # # ###",
  "# #   # ### #        ####     # #         # ### ### ###     #####   ####",
  "#  # # # # #         ###     # # #         # # # # # # #    ## # #   ###",
  "# #   # # ####        ### # # # #           # ### #####     #####   ####",
  "#      # # # #         #   # # # #         # # # # # # #     # #   # ###",
  "# # # # ######        # # # # # ###         ###########     ##### # # ##",
  "##   # # # # #         # # # # # #           # # # ### #   ### #   #  ##",
  "### # # # #####        ## # # # #           ############   ###### # # ##",
  "##     # # # #         # # # # # #           # # ### #     ### # # #  ##",
  "##  # # ##### #        #### ######           ##########   #####  ## # ##",
  "###  # # #   # #       # # # # # #           # #######     ### # #    ##",
  "### # # #   # #         # #######             ########    ####### # # ##",
  "###    #   #   #        ## # # #              ########   #####   # #  ##",
  "### # #   # # # #        ########   #         #######    ########## # ##",
  "#### # # # # # #         # ###     #          #######    ##### # # #  ##",
  "##### # # # # # #         #####   # #          #####    # ###  #### # ##",
  "#####      # # # #        ## #     #           #####   # ##### # # #  ##",
  "##### # # # ######         ##   # # #           ###   # ##### ##### # ##",
  "#####  # # # # # #               # # #          #    # # ####  ### #  ##",
  "####  # # # # ####              # # # #               ######  ##### # ##",
  "####   # # # # # ##            # # # #               # ####  ### # ## ##",
  "###   # ### #######           # #######             ######  #######  ###",
  "###  # # # # # ###           # # # # #             # # ### # ##### # ###",
  "### # # # ##########        # # # ### #           # # ### ####### ## ###",
  "##     # # # # # ###       # # # # # # #         # # # # # ##### # # ###",
  "##  # # #############   # # ### #######       # # # ### ### #######  ###",
  "##   # # # ### ######    # # # # # ### #     # # # # # # # ##### #   ###",
  "##  # ### ############# # # # ########### # # # # ### # # #######   ####",
  "##     # # # ######### # # # # # ##### #   # # # # #   # ####### #  ####",
  "###  ## ############### ### ############# # # # ### # # #########  #####",
  "###    # # ########### # # # # ####### # # # # #   # # # #######   #####",
  "####   ################ # ############### ### # # # # ##########   #####",
  "####     ############### # # # ######### # #   # # # # # ######  #######",
  "#####     ############# ################### # # # # ##########   #######",
  "######        ########## # ############  #   # #   # # #####     #######",
  "#######           ###############     # # # # ### #           ##########",
  "###### #       #               #       # # # # #   #       # # #########",
  "####### # # # # # # # # # # # # # # # # ### ##### # # # # # # # ########",
  "######## # # # # # # # # # # ### # # # # # # # # # # # # # # # #########",
  "######### ### # # # # # # # # # ### # ### ### ### ### # # ### ##########",
  "########## # # # # # # # # # # # # # # # # # # # # # # # # # ###########",
  "################### ####### ####################### ####################"
};




/*
 * what we've going to export...
 */

int main (int argc, char *argv[])
{
  short x0, y0, wd, ht;
  short ewidth, eheight, x, y, i;
  WFONT *tiny, *small, *medium, *big;
  WSERVER *wserver;
  WWIN *win;
  WEVENT *event;
  BITMAP *grafik;
  char buf[40], *msg;

  if (!(grafik = w_xpm2bm(pic)))
    return -1;

  if (!(wserver = w_init())) {
    fprintf(stderr, "error: cpyrgt can't connect to wserver\n");
    return -1;
  }

  if (!(win = w_create(WIDTH, HEIGHT, W_TOP|EV_MOUSE|EV_KEYS))) {
    fprintf(stderr, "error: cpyrgt can't create window\n");
    return -1;
  }

  tiny   = w_loadfont("cour", 9, 0);
  small  = w_loadfont("lucidat", 11, 0);
  medium = w_loadfont("lucidat", 15, 0);
  big    = w_loadfont("lucidat", 27, 0);

  for (x = 0; x < WIDTH; x++)
    w_line(win, x, 0, WIDTH-1-x, HEIGHT-1);
  for (y = 0; y < HEIGHT; y++)
    w_line(win, 0, y, WIDTH-1, HEIGHT-1-y);

  w_setmode(win, M_CLEAR);
  w_pbox(win, 20, 16, WIDTH-40, HEIGHT-32);
  y = 16;

  w_setfont(win, small);
  msg = "welcome to";
  w_printstring(win, Center(small, msg), y, "welcome to");
  y += small->height;

  w_setmode(win, M_DRAW);
  w_putblock(grafik, win, (WIDTH - grafik->width) / 2, y);
  y += grafik->height;

  w_setfont(win, big);
  sprintf(buf, "W %d Release %d", _WMAJ, _WMIN);
  w_printstring(win,  Center(big, buf), y, buf);
  y += big->height;

  w_setfont(win, medium);
  msg = "(C) 02/96 by Torsten Scherer";
  w_printstring(win, Center(medium, msg), y, msg);
  y += medium->height;

  w_setfont(win, tiny);
  msg = "itschere@techfak.uni-bielefeld.de";
  w_printstring(win, Center(tiny, msg), y, msg);
  y += tiny->height;

  w_setfont(win, small);
  msg = "this is experimental software,";
  wd = w_strlen(small, msg);
  x0 = (WIDTH - wd) / 2;
  w_printstring(win, x0, y, msg);

  y0 = y - 1;
  ht = small->height * 2 + 2;
  x0 -= small->widths['W'];
  wd += 2 * small->widths['W'];

  msg = "use it at your own risk!";
  w_printstring(win, Center(small, msg), y + small->height, msg);

  w_querywinsize(win, 1, &ewidth, &eheight);
  w_open(win, (wserver->width-ewidth)/2, (wserver->height-eheight)/2);
  w_flush();

  w_setmode(win, M_INVERS);
  for (i = 0; i < 24; i++) {
    if ((event = w_queryevent(NULL, NULL, NULL, 500))) {
      return 0;
    }
    w_pbox(win, x0, y0, wd, ht);
  }

  return 0;
}
