/*
 * programs/wbiff.c, part of W
 * (C) 94-02/96 by Torsten Scherer (TeSche)
 * itschere@techfak.uni-bielefeld.de
 *
 * - bitmap support by Benjamin Lorenz 9/94
 * - changed for W1R1 by TeSche 12/94
 */

#include <stdio.h>
#include <unistd.h>
#include <pwd.h>
#include <signal.h>
#include <sys/stat.h>

#include <Wlib.h>


#define	MAILBOXPATH "/var/spool/mail/%s"

unsigned char mailfull[] = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0xff, 0xff, 0xff, 0x07,
  0xc0, 0xff, 0xff, 0xff, 0x1f, 0x04, 0x40, 0x00, 0x00, 0x00, 0xd0, 0x05,
  0x40, 0x00, 0x00, 0x00, 0x57, 0x7d, 0x40, 0x1e, 0x00, 0x00, 0x55, 0x7d,
  0x40, 0x00, 0x00, 0x00, 0xd5, 0x7d, 0x60, 0x02, 0x00, 0x00, 0x17, 0x7c,
  0x70, 0x00, 0x7e, 0x00, 0x10, 0x7c, 0x78, 0x00, 0x00, 0x00, 0x10, 0x7e,
  0x7c, 0x00, 0x1e, 0x00, 0x10, 0x7f, 0x7e, 0x00, 0x00, 0x00, 0x90, 0x7f,
  0x7e, 0x00, 0x3e, 0x07, 0xd0, 0x7f, 0x7e, 0x00, 0x00, 0x00, 0xf0, 0x7f,
  0x7e, 0x00, 0x00, 0x00, 0xf0, 0x6f, 0x7e, 0x00, 0x00, 0x00, 0xf0, 0x67,
  0xfe, 0xff, 0xff, 0xff, 0xff, 0x63, 0xbe, 0xaa, 0xaa, 0xaa, 0xea, 0x61,
  0xfe, 0xff, 0xff, 0xff, 0xff, 0x60, 0xfe, 0xff, 0xff, 0xff, 0x7f, 0x60,
  0x06, 0x06, 0x00, 0x00, 0x60, 0x60, 0x06, 0x06, 0x00, 0x00, 0x60, 0x60,
  0x06, 0x06, 0x00, 0x00, 0x60, 0x60, 0x06, 0x06, 0x00, 0x00, 0x60, 0x60,
  0x06, 0x06, 0x00, 0x00, 0x60, 0x60, 0x06, 0xff, 0xff, 0xff, 0xff, 0x7f,
  0x86, 0xff, 0xff, 0xff, 0xff, 0x7f, 0xc6, 0xaf, 0xaa, 0xaa, 0xea, 0x7a,
  0xe6, 0x57, 0x55, 0x55, 0x75, 0x7d, 0xf6, 0xaf, 0xaa, 0xaa, 0xea, 0x7e,
  0xfe, 0x57, 0x55, 0x55, 0x75, 0x7f, 0xfe, 0xaf, 0xaa, 0xaa, 0xea, 0x7f,
  0xfe, 0xff, 0xff, 0xff, 0xff, 0x7f, 0xfe, 0xff, 0xff, 0xff, 0xff, 0x7f,
  0xfe, 0xab, 0xaa, 0xaa, 0xea, 0x7f, 0xfe, 0x55, 0x55, 0x55, 0xf5, 0x6f,
  0xfe, 0xaa, 0xaa, 0xaa, 0xea, 0x67, 0x7e, 0x55, 0x55, 0x55, 0xf5, 0x63,
  0xbe, 0xaa, 0xaa, 0xaa, 0xea, 0x61, 0xfe, 0xff, 0xff, 0xff, 0xff, 0x60,
  0xfe, 0xff, 0xff, 0xff, 0x7f, 0x60, 0x06, 0x06, 0x00, 0x00, 0x60, 0x60,
  0x06, 0x00, 0x00, 0x00, 0x60, 0x00, 0x06, 0xee, 0x9c, 0x37, 0x60, 0x00,
  0x06, 0xfe, 0x36, 0x33, 0x60, 0x00, 0x06, 0xd6, 0x3e, 0x33, 0x60, 0x00,
  0x06, 0xc6, 0xb6, 0xf7, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};

unsigned char mailempty[] = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0xff, 0xff, 0xff, 0xff, 0x7f, 0x80, 0xff, 0xff, 0xff, 0xff, 0x7f,
  0xc0, 0xaf, 0xaa, 0xaa, 0xaa, 0x7a, 0xe0, 0x57, 0x55, 0x55, 0x55, 0x7d,
  0xf0, 0xaf, 0xaa, 0xaa, 0xaa, 0x7e, 0xf8, 0x57, 0x55, 0x55, 0x55, 0x7f,
  0xfc, 0xaf, 0xaa, 0xaa, 0xaa, 0x7f, 0xfe, 0xff, 0xff, 0xff, 0xff, 0x7f,
  0xfe, 0xff, 0xff, 0xff, 0xff, 0x7f, 0xfe, 0xab, 0xaa, 0xaa, 0xea, 0x7f,
  0xfe, 0x55, 0x55, 0x55, 0xf5, 0x6f, 0xfe, 0xaa, 0xaa, 0xaa, 0xea, 0x67,
  0x7e, 0x55, 0x55, 0x55, 0xf5, 0x63, 0xbe, 0xaa, 0xaa, 0xaa, 0xea, 0x61,
  0xfe, 0xff, 0xff, 0xff, 0xff, 0x60, 0xfe, 0xff, 0xff, 0xff, 0x7f, 0x60,
  0x06, 0x06, 0x00, 0x00, 0x60, 0x60, 0x06, 0x06, 0x00, 0x00, 0x60, 0x60,
  0x06, 0x06, 0x00, 0x00, 0x60, 0x60, 0x06, 0x06, 0x00, 0x00, 0x60, 0x60,
  0x06, 0x06, 0x00, 0x00, 0x60, 0x60, 0x06, 0xfe, 0xff, 0xff, 0xff, 0x7f,
  0x06, 0xff, 0xff, 0xff, 0xff, 0x7f, 0x86, 0xaf, 0xaa, 0xaa, 0xea, 0x7a,
  0xc6, 0x57, 0x55, 0x55, 0x75, 0x7d, 0xe6, 0xaf, 0xaa, 0xaa, 0xea, 0x7e,
  0xf6, 0x57, 0x55, 0x55, 0x75, 0x7f, 0xfe, 0xaf, 0xaa, 0xaa, 0xea, 0x7f,
  0xfe, 0xff, 0xff, 0xff, 0xff, 0x7f, 0xfe, 0xff, 0xff, 0xff, 0xff, 0x7f,
  0xfe, 0xab, 0xaa, 0xaa, 0xea, 0x7f, 0xfe, 0x55, 0x55, 0x55, 0xf5, 0x6f,
  0xfe, 0xaa, 0xaa, 0xaa, 0xea, 0x67, 0x7e, 0x55, 0x55, 0x55, 0xf5, 0x63,
  0xbe, 0xaa, 0xaa, 0xaa, 0xea, 0x61, 0xfe, 0xff, 0xff, 0xff, 0xff, 0x60,
  0xfe, 0xff, 0xff, 0xff, 0x7f, 0x60, 0x06, 0x06, 0x00, 0x00, 0x60, 0x00,
  0x06, 0x00, 0x00, 0x00, 0x60, 0x00, 0x06, 0x00, 0x00, 0x00, 0x60, 0x00,
  0x06, 0x00, 0x00, 0x00, 0x60, 0x00, 0x06, 0x00, 0x00, 0x00, 0x60, 0x00,
  0x06, 0x00, 0x00, 0x00, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};

short w_bitmap(win, bitmap, width, height, x0, y0)
     WWIN *win;
     const unsigned char *bitmap;
     short width; short height;
     short x0; short y0;
{
  int i, j, n;
  unsigned char c;
  static unsigned char exp2[] = {1, 2, 4, 8, 16, 32, 64, 128};

  for (j=0; j<height; j++) {
    for (i=0;i<width/8;i++) {
      c = bitmap[6*j+i];
      for (n=0; n<8; n++) {
	if (c & exp2[n])
	  w_plot(win, x0 + 8*i+n, j + y0);
      }
    }
  }
  return 0;
}

void main()
{
  struct passwd *pw;
  char mboxpath[64];
  struct stat st;
  short is_shown;
  WEVENT *ev;
  WSERVER *wserver;
  WWIN *win;

  /* just in case we've started in the background */
  signal(SIGTTOU, SIG_IGN);

  if (!(pw = getpwuid(getuid()))) {
    fprintf(stderr, "error: wbiff can't determine your login name\n");
    exit(1);
  }

  if (!(wserver = w_init())) {
    fprintf(stderr, "error: wbiff can't connect to wserver\n");
    exit(1);
  }

  if (!(win = w_create(48, 48, W_MOVE))) {
    fprintf(stderr, "error: wbiff can't create window\n");
    exit(1);
  }

  if (w_open(win, UNDEF, UNDEF)) {
    w_delete(win);
    fprintf(stderr, "error: wbiff can't open window\n");
    exit(1);
  }

  sprintf(mboxpath, MAILBOXPATH, pw->pw_name);
  is_shown = 2;

  goto do_draw;
  while (42) {

    /* watch events with 10 sec. timeout */
    if ((ev = w_queryevent(NULL, NULL, NULL, 10000))) {

      if ((ev->type == EVENT_GADGET) && (ev->key == GADGET_EXIT)){

	/* we're asked to exit gracefully */
	w_delete(win);

	exit(0);
      }
    }

do_draw:
    if (!stat(mboxpath, &st)) {

      if (st.st_mtime > st.st_atime) {

	if (is_shown != 1) {
	  is_shown = 1;
	  w_setmode(win, M_CLEAR);
	  w_pbox(win, 0, 0, 48, 48);
	  w_setmode(win, M_DRAW);
	  w_bitmap(win, mailfull, 48, 48, 0, 0);
	}

      } else {

	if (is_shown != 0) {
	  is_shown = 0;
	  w_setmode(win, M_CLEAR);
	  w_pbox(win, 0, 0, 48, 48);
	  w_setmode(win, M_DRAW);
	  w_bitmap(win, mailempty, 48, 48, 0, 0);
	}
      }
    }
  }
}
