/*
 * server/wfuncs_server.c, part of W
 * (C) 94-02/96 by Torsten Scherer (TeSche)
 * itschere@techfak.uni-bielefeld.de
 *
 * these functions are known to the server only
 */

#include <unistd.h>
#include "wserver.h"

#include "window.h"


/*
 * a `top' routine
 */

void w_topDown(WINDOW *win)
{
  if (mouse_rcintersect(win->pos.x0, win->pos.y0, win->pos.w, win->pos.h)) {
    mouse_hide();
  }

  clip0 = clip1 = NULL;

  /* fix window hierarchy */

  if (win->parent->childs == win) {
    window_to_bottom(win);
  } else {
    window_to_top(win);
  }
}


/*
 *
 */

void w_changeActiveWindow(void)
{
  WINDOW *win, *top;
  EVENTP ev;

  if (!(win = window_find (glob_mouse.rx, glob_mouse.ry, 1))) {
    /* hmmm..??? */
    return;
  }

  /*
   * find the toplevel window the mouse is in. this is now a bit more subtle
   * as we've got W_TOP windows again and even the glob_backgroundwin has a
   * parent.
   */
  top = win;
  if (!(top->flags & W_TOP) && (top != glob_backgroundwin ) && top->parent) {
    for ( ; top->parent != glob_backgroundwin; top = top->parent)
      ;
  }

  if (win != glob_activewindow) {
    if (glob_activewindow->flags & EV_ACTIVE) {
      ev.len = htons(sizeof(EVENTP));
      ev.type = htons(PAK_EVENT);
      ev.event.type = htons(EVENT_INACTIVE);
      ev.event.win = glob_activewindow->libPtr;
      write(glob_activewindow->cptr->sh, &ev, sizeof(EVENTP));
    }
    glob_activewindow = win;
    if (glob_activewindow->flags & EV_ACTIVE) {
      ev.len = htons(sizeof(EVENTP));
      ev.type = htons(PAK_EVENT);
      ev.event.type = htons(EVENT_ACTIVE);
      ev.event.win = glob_activewindow->libPtr;
      write(glob_activewindow->cptr->sh, &ev, sizeof(EVENTP));
    }
  }

  if (glob_activetopwin != top) {
    mouse_hide();
    windowDeactivate(glob_activetopwin);
    glob_activetopwin = top;
    windowActivate(glob_activetopwin);
  }
}
