/*
 * server/proto.h, part of W
 * (C) 94-02/96 by Torsten Scherer (TeSche)
 * itschere@techfak.uni-bielefeld.de
 */


/*
 * global stuff
 *
 * EV_KEYS and EV_MOUSE already defined in ../lib/Wlib.h
 */

#define	EV_UCONN 0x0001
#define	EV_ICONN 0x0002
#define	EV_CLIENT 0x0004

/* fixed7.wfnt */
#define TITLEFONT 0

/* cour12.wfnt */
#define	MENUFONT 1


/* in client_*.c */

extern void client_do_close (WINDOW *);
extern void client_do_delete (WINDOW *);
extern void client_do_open (WINDOW *);

extern long client_create(CLIENT *cptr, short width, short height,
			  short flags, WWIN *libPtr);
extern long client_create2(CLIENT *cptr, short width, short height,
			   short flags, ushort handle, WWIN *libPtr);
extern short client_open(CLIENT *cptr, ushort handle, short x0, short y0);
extern short client_move(CLIENT *cptr, ushort handle, short x0, short y0);
extern short client_close(CLIENT *cptr, ushort handle);
extern short client_delete(CLIENT *cptr, ushort handle);
extern void client_loadfont(CLIENT *cptr, char *fname, LFONTRETP *lfontrpaket);
extern short client_unloadfont(CLIENT *cptr, short fonthandle);
extern short client_querywinsize(CLIENT *cptr, ushort handle, short effective,
				 short *width, short *height);
extern void client_setmode(CLIENT *cptr, ushort handle, short mode);
extern short client_test(CLIENT *cptr, ushort handle, short x0, short y0);
extern void client_setfont(CLIENT *cptr, ushort handle, short fonthandle);
extern void client_settextstyle(CLIENT *cptr, ushort handle, short flags);
extern short client_querymousepos(CLIENT *cptr, ushort handle, short *x0,
				  short *y0);
extern short client_querywindowpos(CLIENT *cptr, ushort handle, short effective,
				   short *x0, short *y0);
extern void client_setpattern(CLIENT *cptr, ushort handle, ushort pattern);
extern void client_settitle(CLIENT *cptr, ushort handle, char *s);
extern void client_plot(CLIENT *cptr, ushort handle, short x0, short y0);
extern void client_line(CLIENT *cptr, ushort handle, short x0, short y0,
			short xe, short ye);
extern void client_hline(CLIENT *cptr, ushort handle, short x0, short y0,
			 short xe);
extern void client_vline(CLIENT *cptr, ushort handle, short x0, short y0,
			 short ye);
extern void client_box(CLIENT *cptr, ushort handle, short x0, short y0,
		       short width, short height);
extern void client_poly(CLIENT *cptr, ushort handle, short numpoints, short *points);
extern void client_bitblk(CLIENT *cptr, ushort handle, short x0, short y0,
			  short width, short height, short x1, short y1);
extern void client_bitblk2(CLIENT *cptr, ushort shandle, short x0, short y0,
			   short width, short height, ushort dhandle, short x1,
			   short y1);
extern void client_vscroll(CLIENT *cptr, ushort handle, short x0, short y0,
			   short width, short height, short y1);
extern void client_printc(CLIENT *cptr, ushort handle, short x0, short y0,
			  ushort c);
extern void client_prints(CLIENT *cptr, ushort handle, short x0, short y0,
			  uchar *s);
extern void client_circle(CLIENT *cptr, ushort handle, short x0, short y0,
			  short r);
extern short client_status(CLIENT *cptr, CLIENT *clients, short index,
			   STATUS *status);
extern short client_putblockreq(CLIENT *cptr, short rwidth, short rheight,
				short x0, short y0, short width, short height,
				ushort handle, short x1, short y1);
extern void client_putblockdata(CLIENT *cptr, PAKET *rawdata);
extern long client_getblockreq(CLIENT *cptr, ushort handle, short x0, short y0,
			       short width, short height);
extern void client_getblockdata(CLIENT *cptr, PAKET *rawdata);
extern void client_beep(CLIENT *cptr);


/* in cpyrgt.c */

extern int cpyrgt(long arg);


/* in debug.c */

extern void status(void);


/* in font.c */

extern FONT glob_font[MAXFONTS];
extern int font_init(void);
extern short font_loadfont(char *fontname);
extern short font_unloadfont(FONT *fp);
extern int fontStrLen(FONT *f, char *s);


/* somewhere in graph/XXX.c */

extern SCREEN *screen_init(void);
extern REC *clip0, *clip1;
extern GCONTEXT *gc0;


/* in init.c */

extern short initialize(void);


/* in kbd.h */

extern int glob_kbd;
extern int kbdInit(void);


/* in main.c */

extern ushort DefaultPattern[16];
extern int get_rectangle(short width, short height, short *x0, short *y0,
			  char pressed, char released);
extern struct termios glob_termios;
extern long glob_savecount, glob_savetime;
extern short is_terminating;
extern long get_eventmask(long wanted, long timeout, fd_set *retrfd);
extern WEVENT *event_mouse(void);
extern void terminate(int sig, char *msg);
extern void sigroutine(int sig);
extern WINDOW *glob_leftmousepressed, *glob_rightmousepressed;
extern long glob_bytes, glob_pakets;
extern MOUSE glob_mouse;
extern CLIENT *glob_clients;
extern short glob_unixh, glob_ineth;
extern fd_set glob_crfd;
extern SCREEN *glob_screen;
extern short glob_uid;
extern short glob_pakettype;


/* in menu.c */

extern void menu_domenu(void);
extern MENU menu;


/* in misc.c */

extern short intersect(short x0, short y0, short width0, short height0,
		       short x1, short y1, short width1, short height1);
extern REC *wrec_intersect(REC *rec1, REC *rec2);
extern char *ftgets(char *buf, long max, FILE *fp);
extern void *mysignal(int signum, void *);


/* in mouse.c */

extern short mouse_init(void);
extern void mouse_exit(void);
extern void mouse_show(void);
extern void mouse_hide(void);
extern void mouse_move(void);
extern short mouse_rcintersect(short x0, short y0, short width, short height);


/* in recs.c */

#if 0
extern short glob_recsused;
extern WREC glob_rec[MAXRECS];
extern void recs_rebuild(void);
extern void recUpdateDirty(REC *r, int x0, int y0, int width, int height);
#endif


/* in term.c */

extern void cursor_on (void);
extern void cursor_off (void);
extern void clear_scr (void);
extern void makeraw (struct termios *tt);


/* in wfuncs_???.c */

extern void w_topDown(WINDOW *win);
extern void w_changeActiveWindow(void);
