/*
 * server/mouse.c, part of W
 * (C) 95-01/96 by Torsten Scherer (TeSche)
 * itschere@techfak.uni-bielefeld.de
 */

#include <fcntl.h>
#include <unistd.h>
#include "wserver.h"


/*
 * the exported functions
 */

short mouse_init(void)
{
  if ((glob_mouse.fh = open("/dev/mouse", O_RDONLY | O_NDELAY)) < 0) {
    return 1;
  }

  glob_mouse.disabled = 0;
  glob_mouse.visible = 0;

  return 0;
}


void mouse_show(void)
{
  if (glob_mouse.visible || glob_mouse.disabled) {
    return;
  }

  glob_mouse.visible = 1;
  glob_mouse.dx = glob_mouse.rx;
  glob_mouse.dy = glob_mouse.ry;
  (*glob_screen->mouseShow)();
}


void mouse_hide(void)
{
  if (!glob_mouse.visible) {
    return;
  }

  glob_mouse.visible = 0;
  (*glob_screen->mouseHide)();
}


void mouse_move(void)
{
  if (!glob_mouse.visible || glob_mouse.disabled) {
    return;
  }

  /* hardware specific routine will set 'drawn' = 'real' values */
  (*glob_screen->mouseMove)();
}


short mouse_rcintersect(short x0, short y0, short width, short height)
{
	return intersect(glob_mouse.dx, glob_mouse.dy, 16, 16,
			 x0, y0, width, height);
}
