/*
 * misc.c, part of w
 * (C) 94-01/96 by Torsten Scherer (TeSche)
 * itschere@techfak.uni-bielefeld.de
 *
 * miscellaneous tool functions
 */

#include <signal.h>
#include "wserver.h"


/*
 * just say yes or no when asking for intersection of
 * two rectangles
 */

short intersect(short x0, short y0, short width0, short height0, short x1, short y1, short width1, short height1)
{
  /* #0 is the mouse, #1 the other rectangle */

  /* is the lower edge of #1 above the upper edge of #0? */
  if (y1+height1-1 < y0)
    return 0;

  /* is the left edge of #1 right from the right edge of #0? */
  if (x1 > x0+width0-1)
    return 0;

  /* is the upper edge of #1 under the lower edge of #0? */
  if (y1 > y0+height0-1)
    return 0;

  /* is the right edge of #1 left from the left edge of #0? */
  if (x1+width1-1 < x0)
    return 0;

  /* must intersect somehow */
  return 1;
}


/*
 * this one calculates an intersection if there's any
 */

REC *wrec_intersect(REC *rec1, REC *rec2)
{
  static REC rec;

  if (rec2->x0 <= rec1->x0) {
    rec.x0 = rec1->x0;
    if ((rec.w = MIN(rec2->x0+rec2->w, rec1->x0+rec1->w) - rec1->x0) <= 0)
      return 0;
  } else {
    rec.x0 = rec2->x0;
    if ((rec.w = MIN(rec2->x0+rec2->w, rec1->x0+rec1->w) - rec2->x0) <= 0)
      return 0;
  }

  if (rec2->y0 <= rec1->y0) {
    rec.y0 = rec1->y0;
    if ((rec.h = MIN(rec2->y0+rec2->h, rec1->y0+rec1->h) - rec1->y0) <= 0)
      return 0;
  } else {
    rec.y0 = rec2->y0;
    if ((rec.h = MIN(rec2->y0+rec2->h, rec1->y0+rec1->h) - rec2->y0) <= 0)
      return 0;
  }

  return &rec;
}


/*
 * get a string from a file pointer but rip off any CR's and LF's
 */

char *ftgets(char *buf, long max, FILE *fp)
{
  char *ret, *ptr;

  if ((ret = fgets(buf, max, fp))) {
    ptr = ret;
    while (*ptr) {
      if ((*ptr == 10) || (*ptr == 13)) {
	*ptr = 0;
      } else {
	ptr++;
      }
    }
  }

  return ret;
}


/*
 * my own way to install signal handlers, always != SA_ONESHOT
 */

void *mysignal(int signum, void *handler)
{
#ifdef __MINT__
  return signal(signum, handler);
#else
  struct sigaction sa, so;

  sa.sa_handler = handler;
  sa.sa_mask = 0;
  sa.sa_flags = 0;
#if 0
  sa.sa_restorer = NULL;
#endif
  sigaction(signum, &sa, &so);

  return so.sa_handler;
#endif
}
