/*
 * server/kbd.c, part of W
 * (C) 02/96 by Torsten Scherer (TeSche)
 * itschere@techfak.uni-bielefeld.de
 *
 * CHANGES:
 * - included support for NetBSD-Amiga /dev/kbd, Phx 02/96
 */

#include <fcntl.h>
#include <stdio.h>
#include <sys/ioctl.h>

#ifdef sun
#include <sundev/kbio.h>
#define KBD "/dev/kbd"
#endif

#ifdef __NetBSD__
#include <amiga/dev/kbdreg.h>
#define KBD "/dev/kbd"
#endif

/*
 *
 */

int glob_kbd;


/*
 * the `big' init function for the keyboard...
 */

#if defined(__MINT__) || defined(linux)

int kbdInit(void)
{
  /* no special treatment necessary */
  glob_kbd = 0;
  return 0;
}

#elif defined(sun) || defined(__NetBSD__)

int kbdInit(void)
{
  int arg;

  if ((glob_kbd = open(KBD, O_RDONLY)) < 0) {
    fprintf(stderr, "error: can't open keyboard\n");
    return -1;
  }

  arg = 1;
  ioctl(glob_kbd, KIOCSDIRECT, &arg);

  return 0;
}

#else

#error operating system not supported by server/kbd.c

#endif
