/*
 * server/graph/packed/text.c, part of W
 * (C) 94-02/96 by Torsten Scherer (TeSche)
 * itschere@techfak.uni-bielefeld.de
 *
 * character output routines for the Atari graphics driver
 *
 * CHANGES:
 *
 * - more sign extension bug fixes. ++kay, 1/96
 * - added clipping. ++kay, 1/96
 * - speedup for printchar. ++kay, 2/96
 * - real but slow clipping for printchar. ++kay, 2/96
 * - hand tuned printc() so that prints() (which inlines printc() is now
 *   about 10% faster), ++kay, 2/96
 */

#include <stdio.h>
#include "../../../lib/Wlib.h"
#include "../../config.h"
#include "../../types.h"
#include "../../pakets.h"
#include "../../proto.h"
#include "../gproto.h"
#include "../clip.h"
#include "packed.h"


static ushort tmpbm_data[(64*100)/16];
#ifdef MONOCHROME
static BITMAP tmpbm = {64, 100, BM_PACKEDMONO,
			 4, 64>>5, 1, (ulong *)tmpbm_data};
#else
static BITMAP tmpbm = {64, 100, BM_PACKEDCOLOR,
			 2, 64>>4, 1, tmpbm_data};
#endif
static REC tmpclip = {0, 0, 64, 100, 63, 99, NULL};

inline void FUNCTION(printc)(bm, x0, y0, c)
     BITMAP *bm;
     register long x0;
     register long y0;
     ulong c;
{
  register long cwidth, cheight;
  register ushort *dptr, *dlptr;
  register ushort dbit, dlbit, dldata;
  register ulong *cptr;
  register short lwidth;
  FONT *f = gc0->font;
  BITMAP *save_bm = NULL;
  long save_x0, save_y0;

  (void)&save_x0; (void)&save_y0;

/*
 * reuse some variables to ease gcc's life a bit.
 */
#define cbit  x0
#define clong y0

  c &= 0xff;
  cheight = f->hdr.height;
  cwidth = f->hdr.widths[c];

  /*
   * if the character needs clipping we draw it to a temporary bitmap
   * and copy it to the other bitmap.
   */
  if (BOX_NEEDS_CLIPPING (x0, y0, cwidth, cheight, clip0)) {
    if (cwidth > tmpbm.width || cheight+1 > tmpbm.height)
      return;
    save_bm = bm;
    save_x0 = x0;
    save_y0 = y0;
    bm = &tmpbm;
    x0 = 0;
    y0 = 0;
  }

  dbit = 32768 >> (x0 & 15);
#ifdef MONOCHROME
  dptr = (ushort *)bm->data + y0 * (bm->upl << 1) + (x0 >> 4);
#else
  dptr = (ushort *)bm->data + y0 * bm->upl + (x0 >> 4) * bm->planes;
#endif

  cbit = 31;
  cptr = f->data + f->offsets[c];
  clong = *cptr++;

  if (!(gc0->textstyle & F_UNDERLINE)) {
    cheight++;
  }

  if (gc0->textstyle & F_INVERS) {

    while (--cheight) {
      dlbit = dbit;
      dlptr = dptr;
      lwidth = cwidth;
      dldata = *dlptr;
      while (--lwidth >= 0) {
	dldata |= dlbit;
	if (clong & (1L << cbit)) {
	  dldata &= ~dlbit;
	}
	if (--cbit < 0) {
	  cbit = 31;
	  clong = *cptr++;
	}
	if (!(dlbit >>= 1)) {
	  dlbit = 32768;
	  *dlptr = dldata;
#ifdef MONOCHROME
	  dlptr++;
#else
	  dlptr += bm->planes;
#endif
	  dldata = *dlptr;
	}
      }
      *dlptr = dldata;
#ifdef MONOCHROME
      dptr += bm->upl << 1;
#else
      dptr += bm->upl;
#endif
    }

    if (gc0->textstyle & F_UNDERLINE) {
      lwidth = cwidth;
      dldata = *dptr;
      while (--lwidth >= 0) {
	dldata &= ~dbit;
	if (!(dbit >>= 1)) {
	  dbit = 32768;
	  *dptr = dldata;
#ifdef MONOCHROME
	  dptr++;
#else
	  dptr += bm->planes;
#endif
	  dldata = *dptr;
	}
      }
      *dptr = dldata;
    }

  } else {

    while (--cheight) {
      dlbit = dbit;
      dlptr = dptr;
      lwidth = cwidth;
      dldata = *dlptr;
      while (--lwidth >= 0) {
	dldata |= dlbit;
	if (!(clong & (1L << cbit))) {
	  dldata &= ~dlbit;
	}
	if (--cbit < 0) {
	  cbit = 31;
	  clong = *cptr++;
	}
	if (!(dlbit >>= 1)) {
	  dlbit = 32768;
	  *dlptr = dldata;
#ifdef MONOCHROME
	  dlptr++;
#else
	  dlptr += bm->planes;
#endif
	  dldata = *dlptr;
	}
      }
      *dlptr = dldata;
#ifdef MONOCHROME
      dptr += bm->upl << 1;
#else
      dptr += bm->upl;
#endif
    }

    if (gc0->textstyle & F_UNDERLINE) {
      lwidth = cwidth;
      dldata = *dptr;
      while (--lwidth >= 0) {
	dldata |= dbit;
	if (!(dbit >>= 1)) {
	  dbit = 32768;
	  *dptr = dldata;
#ifdef MONOCHROME
	  dptr++;
#else
	  dptr += bm->planes;
#endif
	  dldata = *dptr;
	}
      }
      *dptr = dldata;
    }
  }

  if (save_bm) {
    REC *save_clip1 = clip1;
    clip1 = clip0;
    clip0 = &tmpclip;
    (*theScreen->bitblk) (bm, 0, 0, f->hdr.widths[c], f->hdr.height,
			  save_bm, save_x0, save_y0);
    clip0 = clip1;
    clip1 = save_clip1;
  }
}

void FUNCTION(prints)(bm, x0, y0, s)
     BITMAP *bm;
     long x0;
     long y0;
     uchar *s;
{
  uchar *widths = gc0->font->hdr.widths;

  while (*s) {
    FUNCTION(printc)(bm, x0, y0, *s);
    x0 += widths[*s++];
  }
}
