/*
 * server/graph/packed/scroll.c, part of W
 * (C) 94-02/96 by Torsten Scherer (TeSche)
 * itschere@techfak.uni-bielefeld.de
 *
 * scrolling routines for the Atari graphics driver
 *
 * CHANGES:
 *
 * - major speedups in W0R8. ++kay, 10/94
 * - added clipping. ++kay, 1/96
 */

#include <stdio.h>
#include "../../../lib/Wlib.h"
#include "../../config.h"
#include "../../types.h"
#include "../../pakets.h"
#include "../../proto.h"
#include "../clip.h"
#include "packed.h"


/*
 * this one is a specialized version of the bitblk routine, mainly used for
 * scrolling in the same bitmap, it uses aligned copy where possible and is
 * therefore a *bit* :) faster...
 *
 * TeSche 01/96: why didn't the monochrome version used 32-bit access so far?
 */

void FUNCTION(scroll)(bm, x0, y0, width, height, y1)
     BITMAP *bm;
     long x0;
     long y0;
     long width;
     register long height;
     long y1;
{
#ifdef MONOCHROME
  register ulong *sptr, *lsptr, *dptr, *ldptr;
#else
  register ushort *sptr, *lsptr, *dptr, *ldptr;
#endif
  register long nunits;   /* ushorts or ulongs */
  register ulong lmask = 0, rmask = 0;
  long lbit, todo, x1 = x0;
  short lnunits;

  if ((y0 == y1) || !width) {
    return;
  }

  if (CLIP_BITBLIT (x0, y0, width, height, x1, y1, clip0, clip0)) {
    return;
  }

  if (y1 < y0) {

    /* scroll up */

#ifdef MONOCHROME
    sptr = (ulong *)bm->data + y0 * bm->upl + (x0 >> 5);
    dptr = (ulong *)bm->data + y1 * bm->upl + (x0 >> 5);

    if ((lbit = x0 & 31)) {
      if ((todo = 32 - lbit) > width) {
	todo = width;
      }
      lmask = bfmask32[lbit][todo-1];
      width -= todo;
    }
    nunits = width >> 5;
    if ((todo = width & 31)) {
      rmask = bfmask32[0][todo-1];
    }
#else
    sptr = bm->data + y0 * bm->upl + (x0 >> 4) * bm->planes;
    dptr = bm->data + y1 * bm->upl + (x0 >> 4) * bm->planes;

    if ((lbit = x0 & 15)) {
      if ((todo = 16 - lbit) > width) {
	todo = width;
      }
      lmask = bfmask16[lbit][todo-1];
      width -= todo;
    }
    nunits = width >> 4;
    if ((todo = width & 15)) {
      rmask = bfmask16[0][todo-1];
    }
#endif

    while (--height >= 0) {
      lsptr = sptr;
      ldptr = dptr;

      if (lmask) {
#ifdef MONOCHROME
	*ldptr++ = (*ldptr & ~lmask) | (*lsptr++ & lmask);
#else
	*ldptr = (*ldptr & ~lmask) | (*lsptr & lmask);
	ldptr += bm->planes;
	lsptr += bm->planes;
#endif
      }

      lnunits = nunits;
      while (--lnunits >= 0) {
#ifdef MONOCHROME
	*ldptr++ = *lsptr++;
#else
	*ldptr = *lsptr;
	lsptr += bm->planes;
	ldptr += bm->planes;
#endif
      }

      if (rmask) {
	*ldptr = (*ldptr & ~rmask) | (*lsptr & rmask);
      }

      sptr += bm->upl;
      dptr += bm->upl;
    }

  } else {

    /* scroll down */

#ifdef MONOCHROME
    sptr = ((ulong *)bm->data) + (y0 + height - 1) * bm->upl + (x0 >> 5);
    dptr = ((ulong *)bm->data) + (y1 + height - 1) * bm->upl + (x0 >> 5);

    if ((lbit = x0 & 31)) {
      if ((todo = 32 - lbit) > width) {
	todo = width;
      }
      lmask = bfmask32[lbit][todo-1];
      width -= todo;
    }
    nunits = width >> 5;
    if ((todo = width & 31)) {
      rmask = bfmask32[0][todo-1];
    }
#else
    sptr = bm->data + (y0 + height - 1) * bm->upl + (x0 >> 4) * bm->planes;
    dptr = bm->data + (y1 + height - 1) * bm->upl + (x0 >> 4) * bm->planes;

    if ((lbit = x0 & 15)) {
      if ((todo = 16 - lbit) > width) {
	todo = width;
      }
      lmask = bfmask16[lbit][todo-1];
      width -= todo;
    }
    nunits = width >> 4;
    if ((todo = width & 15)) {
      rmask = bfmask16[0][todo-1];
    }
#endif

    while (--height >= 0) {
      lsptr = sptr;
      ldptr = dptr;

      if (lmask) {
#ifdef MONOCHROME
	*ldptr++ = (*ldptr & ~lmask) | (*lsptr++ & lmask);
#else
	*ldptr = (*ldptr & ~lmask) | (*lsptr & lmask);
	ldptr += bm->planes;
	lsptr += bm->planes;
#endif
      }

      lnunits = nunits;
      while (--lnunits >= 0) {
#ifdef MONOCHROME
	*ldptr++ = *lsptr++;
#else
	*ldptr = *lsptr;
	lsptr += bm->planes;
	ldptr += bm->planes;
#endif
      }

      if (rmask) {
	*ldptr = (*ldptr & ~rmask) | (*lsptr & rmask);
      }

      sptr -= bm->upl;
      dptr -= bm->upl;
    }
  }
}
