/*
 * server/graph/packed/point.c, part of W
 * (C) 94-02/96 by Torsten Scherer (TeSche)
 * itschere@techfak.uni-bielefeld.de
 *
 * routines dealing with single points for the Atari graphics driver
 *
 * CHANGES:
 *
 * - added dplot(). ++kay, 1/96
 * - added clipping. ++kay, 1/96
 */

#include <stdio.h>
#include "../../../lib/Wlib.h"
#include "../../config.h"
#include "../../types.h"
#include "../../pakets.h"
#include "../../proto.h"
#include "../gproto.h"
#include "../clip.h"
#include "packed.h"


/*
 *
 */

void FUNCTION(plot)(bm, x0, y0)
     register BITMAP *bm;
     register long x0;
     register long y0;
{
#ifdef MONOCHROME
  register ulong *ptr, bit;
#else
  register ushort *ptr, bit;
#endif

  if (CLIP_POINT (x0, y0, clip0)) {
    return;
  }

#ifdef MONOCHROME
  bit = 0x80000000 >> (x0 & 31);
  ptr = (ulong *)bm->data + y0 * bm->upl + (x0 >> 5);
#else
  bit = 0x8000 >> (x0 & 15);
  ptr = (ushort *)bm->data + y0 * bm->upl + (x0 >> 4) * bm->planes;
#endif

  switch(gc0->drawmode) {
    case M_CLEAR:
      *ptr &= ~bit;
      break;
    case M_DRAW:
      *ptr |= bit;
      break;
    case M_INVERS:
      *ptr ^= bit;
      break;
  }
}


void FUNCTION(dplot)(bm, x0, y0)
     register BITMAP *bm;
     register long x0;
     register long y0;
{
#ifdef MONOCHROME
  register ulong *ptr, bit;
#else
  register ushort *ptr, bit;
#endif

  if (CLIP_POINT (x0, y0, clip0)) {
    return;
  }

#ifdef MONOCHROME
  bit = 0x80000000 >> (x0 & 31);
  ptr = (ulong *)bm->data + y0 * bm->upl + (x0 >> 5);
#else
  bit = 0x8000 >> (x0 & 15);
  ptr = (ushort *)bm->data + y0 * bm->upl + (x0 >> 4) * bm->planes;
#endif

  *ptr &= ~bit;
  *ptr |= gc0->pattern[y0 & 15] & bit;
}


long FUNCTION(test)(bm, x0, y0)
     register BITMAP *bm;
     register long x0;
     register long y0;
{
#ifdef MONOCHROME
  register ulong *ptr, bit;
#else
  register ushort *ptr, bit;
#endif

  if (CLIP_POINT (x0, y0, clip0)) {
    return -1;
  }

#ifdef MONOCHROME
  bit = 0x80000000 >> (x0 & 31);
  ptr = (ulong *)bm->data + y0 * bm->upl + (x0 >> 5);
#else
  bit = 0x8000 >> (x0 & 15);
  ptr = (ushort *)bm->data + y0 * bm->upl + (x0 >> 4) * bm->planes;
#endif

  if (*ptr & bit) {
    return 1;
  }

  return 0;
}
