/*
 * server/graph/packed.h, part of w
 * (C) 94-01/96 by Torsten Scherer (TeSche)
 * itschere@techfak.uni-bielefeld.de
 *
 * prototypes for `packed' graphic routines
 */


#ifdef MONOCHROME
#define FUNCTION(name) packed_mono_ ## name
#else
#define FUNCTION(name) packed_color_ ## name
#endif


/*
 * internal
 */

extern ushort bfmask16[16][16];
extern ulong bfmask32[32][32];


/*
 * exported
 */

extern void packed_color_mouseShow(void);
extern void packed_color_mouseHide(void);
extern void packed_color_mouseMove(void);
extern void packed_color_plot(BITMAP *bm, long x0, long y0);
extern void packed_color_dplot(BITMAP *bm, long x0, long y0);
extern long packed_color_test(BITMAP *bm, long x0, long y0);
extern void packed_color_line(BITMAP *bm, long x0, long y0, long xe, long ye);
extern void packed_color_hline(BITMAP *bm, long x0, long y0, long xe);
extern void packed_color_vline(BITMAP *bm, long x0, long y0, long ye);
extern void packed_color_box(BITMAP *bm, long x0, long y0, long width, long height);
extern void packed_color_pbox(BITMAP *bm, long x0, long y0, long width, long height);
extern void packed_color_dline(BITMAP *bm, long x0, long y0, long xe, long ye);
extern void packed_color_dvline(BITMAP *bm, long x0, long y0, long ye);
extern void packed_color_dhline(BITMAP *bm, long x0, long y0, long xe);
extern void packed_color_dbox(BITMAP *bm, long x0, long y0, long width, long height);
extern void packed_color_dpbox(BITMAP *bm, long x0, long y0, long width, long height);
extern void packed_color_bitblk(BITMAP *bm, long x0, long y0, long width, long height, BITMAP *bm1, long x1, long y1);
extern void packed_color_scroll(BITMAP *bm, long x0, long y0, long width, long height, long y1);
extern void packed_color_printc(BITMAP *bm, long x0, long y0, ulong c);
extern void packed_color_prints(BITMAP *bm, long x0, long y0, uchar *s);
extern BITMAP *packed_color_getblock(BITMAP *bm0, short x0, short y0, short width, short height);
extern void packed_color_putblock(BITMAP *bm0, short x0, short y0, short width, short height, BITMAP *bm1, short x1, short y1);

extern void packed_mono_mouseShow(void);
extern void packed_mono_mouseHide(void);
extern void packed_mono_mouseMove(void);
extern void packed_mono_plot(BITMAP *bm, long x0, long y0);
extern void packed_mono_dplot(BITMAP *bm, long x0, long y0);
extern long packed_mono_test(BITMAP *bm, long x0, long y0);
extern void packed_mono_line(BITMAP *bm, long x0, long y0, long xe, long ye);
extern void packed_mono_hline(BITMAP *bm, long x0, long y0, long xe);
extern void packed_mono_vline(BITMAP *bm, long x0, long y0, long ye);
extern void packed_mono_box(BITMAP *bm, long x0, long y0, long width, long height);
extern void packed_mono_pbox(BITMAP *bm, long x0, long y0, long width, long height);
extern void packed_mono_dline(BITMAP *bm, long x0, long y0, long xe, long ye);
extern void packed_mono_dvline(BITMAP *bm, long x0, long y0, long ye);
extern void packed_mono_dhline(BITMAP *bm, long x0, long y0, long xe);
extern void packed_mono_dbox(BITMAP *bm, long x0, long y0, long width, long height);
extern void packed_mono_dpbox(BITMAP *bm, long x0, long y0, long width, long height);
extern void packed_mono_bitblk(BITMAP *bm, long x0, long y0, long width, long height, BITMAP *bm1, long x1, long y1);
extern void packed_mono_scroll(BITMAP *bm, long x0, long y0, long width, long height, long y1);
extern void packed_mono_printc(BITMAP *bm, long x0, long y0, ulong c);
extern void packed_mono_prints(BITMAP *bm, long x0, long y0, uchar *s);
extern BITMAP *packed_mono_getblock(BITMAP *bm0, short x0, short y0, short width, short height);
extern void packed_mono_putblock(BITMAP *bm0, short x0, short y0, short width, short height, BITMAP *bm1, short x1, short y1);
