/*
 * server/graph/packed/mouse.c, part of W
 * (C) 94-02/96 by Torsten Scherer (TeSche)
 * itschere@techfak.uni-bielefeld.de
 *
 * mouse show/hide/move routines for the Atari graphics driver
 *
 * CHANGES:
 */

#include <stdio.h>
#include "../../../lib/Wlib.h"
#include "../../config.h"
#include "../../types.h"
#include "../../pakets.h"
#include "../../proto.h"
#include "../gproto.h"
#include "packed.h"


/*
 * the background buffer
 */

static ushort mbackground[16];


/*
 * the mouse functions
 *
 * all of these assume that it's legal to access memory beyond the bottom
 * of the screen for some lines. for MiNT and Linux68k this seems to be legal.
 */

void FUNCTION(mouseShow)(void)
{
  register ushort *ptr, bit, *bptr, *moptr, *mpptr;
  register ulong l;
  long height, wpl;

  /*
   * draw the mouse, hmm, this merely are bit block
   * operations on a block which size is definitely
   * known and which targets are definitely word aligned
   */

  bit = glob_mouse.dx & 15;
#ifdef MONOCHROME
  wpl = glob_screen->bm.upl << 1;
  ptr = (ushort *)glob_screen->bm.data + glob_mouse.dy * wpl + (glob_mouse.dx >> 4);
#else
  wpl = glob_screen->bm.upl;
  ptr = (ushort *)glob_screen->bm.data + glob_mouse.dy * wpl + (glob_mouse.dx >> 4) * glob_screen->bm.planes;
#endif
  if ((height = glob_screen->bm.height - glob_mouse.dy) > 16) {
    height = 16;
  }

  bptr = mbackground;
  moptr = moutline;
  mpptr = mpointer;

  if (glob_screen->bm.width - glob_mouse.dx > 16) {

    while (height--) {
#ifdef MONOCHROME
      /* be carefull, this is a long-access to a short-boundary! luckily this
       * is no problem for a 68000'er, and nobody so far wanted to run this on
       * any other processor. however, if you want to run it on a Sparc with
       * BW2 graphics this will cause a bus-error. your would then have to use
       * a construct like `(ptr[0] << 16) + ptr[1]'.
       */
      l = *(ulong *)ptr;
#else
      l = (ptr[0] << 16) + ptr[glob_screen->bm.planes];
#endif
      *bptr++ = l >> (16 - bit);
#ifdef MONOCHROME
      *(ulong *)ptr = (l & ~(*moptr++ << (16 - bit))) | (*mpptr++ << (16 - bit));
#else
      l = (l & ~(*moptr++ << (16 - bit))) | (*mpptr++ << (16 - bit));
      ptr[0] = l >> 16;
      ptr[glob_screen->bm.planes] = l;
#endif
      ptr += wpl;
    }

  } else {

    while (height--) {
      *bptr++ = (l = *ptr) << bit;
      *ptr = (l & ~*moptr++ >> bit) | *mpptr++ >> bit;
      ptr += wpl;
    }
  }
}


void FUNCTION(mouseHide)(void)
{
#ifndef MONOCHROME
  register ulong l;
#endif
  register ushort *ptr, bit, *bptr;
  long width, height, wpl;

  /*
   * this essentially means: restore the background
   */

  bit = glob_mouse.dx & 15;
#ifdef MONOCHROME
  wpl = glob_screen->bm.upl << 1;
  ptr = (ushort *)glob_screen->bm.data + glob_mouse.dy * wpl + (glob_mouse.dx >> 4);
#else
  wpl = glob_screen->bm.upl;
  ptr = (ushort *)glob_screen->bm.data + glob_mouse.dy * wpl + (glob_mouse.dx >> 4) * glob_screen->bm.planes;
#endif
  if ((width = glob_screen->bm.width - glob_mouse.dx) > 16) {
    width = 16;
  }
  width--;

  if ((height = glob_screen->bm.height - glob_mouse.dy) > 16) {
    height = 16;
  }

  bptr = mbackground;
  if (glob_screen->bm.width - glob_mouse.dx > 16) {
    while (height--) {
#ifdef MONOCHROME
      *(ulong *)ptr = (*(ulong *)ptr & ~(0xffff << (16 - bit))) | (*bptr++ << (16 - bit));
#else
      l = (ptr[0] << 16) + ptr[glob_screen->bm.planes];
      l = (l & ~(0xffff << (16 - bit))) | (*bptr++ << (16 - bit));
      ptr[0] = l >> 16;
      ptr[glob_screen->bm.planes] = l;
#endif
      ptr += wpl;
    }
  } else {
    while (height--) {
      *ptr = (*ptr & ~(0xffff >> bit)) | (*bptr++ >> bit);
      ptr += wpl;
    }
  }
}


void FUNCTION(mouseMove)(void)
{
  register ushort *ptr, bit, *bptr, *moptr, *mpptr;
  register ulong l;
  long width, height, wpl;

  /*
   * restore background on old position
   */

  bit = glob_mouse.dx & 15;
#ifdef MONOCHROME
  wpl = glob_screen->bm.upl << 1;
  ptr = (ushort *)glob_screen->bm.data + glob_mouse.dy * wpl + (glob_mouse.dx >> 4);
#else
  wpl = glob_screen->bm.upl;
  ptr = (ushort *)glob_screen->bm.data + glob_mouse.dy * wpl + (glob_mouse.dx >> 4) * glob_screen->bm.planes;
#endif
  if ((width = glob_screen->bm.width - glob_mouse.dx) > 16) {
    width = 16;
  }
  width--;

  if ((height = glob_screen->bm.height - glob_mouse.dy) > 16) {
    height = 16;
  }

  bptr = mbackground;
  if (glob_screen->bm.width - glob_mouse.dx > 16) {
    while (height--) {
#ifdef MONOCHROME
      *(ulong *)ptr = (*(ulong *)ptr & ~(0xffff << (16 - bit))) | (*bptr++ << (16 - bit));
#else
      l = (ptr[0] << 16) + ptr[glob_screen->bm.planes];
      l = (l & ~(0xffff << (16 - bit))) | (*bptr++ << (16 - bit));
      ptr[0] = l >> 16;
      ptr[glob_screen->bm.planes] = l;
#endif
      ptr += wpl;
    }
  } else {
    while (height--) {
      *ptr = (*ptr & ~(0xffff >> bit)) | (*bptr++ >> bit);
      ptr += wpl;
    }
  }

  glob_mouse.dx = glob_mouse.rx;
  glob_mouse.dy = glob_mouse.ry;

  /*
   * and draw mouse on new position
   */

  bit = glob_mouse.dx & 15;
#ifdef MONOCHROME
  ptr = (ushort *)glob_screen->bm.data + glob_mouse.dy * wpl + (glob_mouse.dx >> 4);
#else
  ptr = (ushort *)glob_screen->bm.data + glob_mouse.dy * wpl + (glob_mouse.dx >> 4) * glob_screen->bm.planes;
#endif
  if ((height = glob_screen->bm.height - glob_mouse.dy) > 16) {
    height = 16;
  }

  bptr = mbackground;
  moptr = moutline;
  mpptr = mpointer;
  if (glob_screen->bm.width - glob_mouse.dx > 16) {
    while (height--) {
#ifdef MONOCHROME
      l = *(ulong *)ptr;
#else
      l = (ptr[0] << 16) + ptr[glob_screen->bm.planes];
#endif
      *bptr++ = l >> (16 - bit);
      l = (l & ~(*moptr++ << (16 - bit))) | (*mpptr++ << (16 - bit));
#ifdef MONOCHROME
      *(ulong *)ptr = l;
#else
      ptr[0] = l >> 16;
      ptr[glob_screen->bm.planes] = l;
#endif
      ptr += wpl;
    }
  } else {
    while (height--) {
      *bptr++ = (l = *ptr) << bit;
      *ptr = (l & ~*moptr++ >> bit) | *mpptr++ >> bit;
      ptr += wpl;
    }
  }
}
