/*
 * server/graph/packed/block.c, part of W
 * (C) 94-02/96 by Torsten Scherer (TeSche)
 * itschere@techfak.uni-bielefeld.de
 *
 * getblock/putblock routines for the PACKED driver, they're almost trivial
 * as they just call bitblk() to do the main work
 */

#include <stdio.h>
#include <stdlib.h>
#include "../../../lib/Wlib.h"
#include "../../config.h"
#include "../../types.h"
#include "../../pakets.h"
#include "../../proto.h"
#include "../clip.h"
#include "../gproto.h"
#include "packed.h"


/*
 *
 */

BITMAP *FUNCTION(getblock) (BITMAP *bm0, short x0, short y0, short width, short height)
{
  BITMAP *ret;

  if ((width < 1) || (height < 1)) {
    return NULL;
  }

  if (!(ret = malloc (sizeof (BITMAP)))) {
    return NULL;
  }

  ret->width = (width + 31) & ~31;
  ret->height = height;
#ifdef MONOCHROME
  ret->type = BM_PACKEDMONO;
  ret->unitsize = 4;
  ret->upl = ret->width >> 5;
#else
  ret->type = BM_PACKEDCOLOR;
  ret->unitsize = 2;
  ret->upl = ret->width >> 4;
#endif
  ret->planes = 1;
  if (!(ret->data = malloc (ret->unitsize * ret->upl * ret->height))) {
    free(ret);
    return NULL;
  }

  /* do the bitblk */
  clip0 = clip1 = NULL;
  (*theScreen->bitblk)(bm0, x0, y0, width, height, ret, 0, 0);

#ifndef MONOCHROME
  ret->type = BM_PACKEDMONO;
  ret->unitsize = 4;
  ret->upl >>= 1;
#endif

  return ret;
}


void FUNCTION(putblock) (BITMAP *bm0, short x0, short y0, short width, short height,
			 BITMAP *bm1, short x1, short y1)
{
#ifndef MONOCHROME
  /* bm0 is the BM_PACKEDMONO bitmap we copy from, but bm1 is BM_PACKEDCOLOR
   */
  bm0->type = BM_PACKEDCOLOR;
  bm0->unitsize = 2;
  bm0->upl <<= 1;
#endif

  /* do the bitblk */
  clip0 = clip1 = NULL;
  (*theScreen->bitblk)(bm0, x0, y0, width, height, bm1, x1, y1);
}
