/*
 * server/graph/netbsd_amiga.c, part of W
 * (C) 94-02/96 TeSche (Torsten Scherer)
 * itschere@techfak.uni-bielefeld.de
 *
 * this file:
 * (C) 01/96-02/96 Phx (Frank Wille)
 * frank@phoenix.owl.de
 *
 * init code for NetBSD Amiga graphics devices
 *
 * CHANGES:
 * (02-Feb-96) Adapted for W1R2PL3
 * (08-Feb-96) Adapted for W1R3a (bm.wpl -> bm.upl)
 */

#ifdef __NetBSD__

#include <stdio.h>
#include <fcntl.h>
#include <stdio.h>
#include <unistd.h>
#include <sys/ioctl.h>
#include <sys/mman.h>
#include <amiga/dev/grfioctl.h>
#include "../../lib/Wlib.h"
#include "../config.h"
#include "../types.h"
#include "gproto.h"
#include "direct8/direct8.h"
#include "generic/generic.h"


/* 
   Support for all Amiga graphics devices, except /dev/grf0 (=Amiga Custom
   Chipset) and /dev/grf4 (=A2024 Monitor).
   Currently tested for /dev/grf5 (Cybervision 64) only. 
*/

SCREEN netbsd_grf_screen[6] = {
  {
    {},
    NULL,NULL
  },
  {
    {},
    NULL, direct8_mouseShow, direct8_mouseHide, direct8_mouseMove,
    direct8_plot, direct8_test, direct8_line, direct8_hline, direct8_vline,
    generic_box, generic_pbox, direct8_dvline, direct8_dhline, generic_dbox,
    generic_dpbox, generic_circ, generic_pcirc, direct8_bitblk,
    direct8_scroll, direct8_printc, direct8_prints, direct8_dplot,
    direct8_dline, generic_dcirc, generic_dpcirc, generic_poly,
    generic_dpoly, generic_ppoly, generic_dppoly,
    direct8_getblock, direct8_putblock
  },
  {
    {},
    NULL, direct8_mouseShow, direct8_mouseHide, direct8_mouseMove,
    direct8_plot, direct8_test, direct8_line, direct8_hline, direct8_vline,
    generic_box, generic_pbox, direct8_dvline, direct8_dhline, generic_dbox,
    generic_dpbox, generic_circ, generic_pcirc, direct8_bitblk,
    direct8_scroll, direct8_printc, direct8_prints, direct8_dplot,
    direct8_dline, generic_dcirc, generic_dpcirc, generic_poly,
    generic_dpoly, generic_ppoly, generic_dppoly,
    direct8_getblock, direct8_putblock
  },
  {
    {},
    NULL, direct8_mouseShow, direct8_mouseHide, direct8_mouseMove,
    direct8_plot, direct8_test, direct8_line, direct8_hline, direct8_vline,
    generic_box, generic_pbox, direct8_dvline, direct8_dhline, generic_dbox,
    generic_dpbox, generic_circ, generic_pcirc, direct8_bitblk,
    direct8_scroll, direct8_printc, direct8_prints, direct8_dplot,
    direct8_dline, generic_dcirc, generic_dpcirc, generic_poly,
    generic_dpoly, generic_ppoly, generic_dppoly,
    direct8_getblock, direct8_putblock
  },
  {
    {},
    NULL,NULL
  },
  {
    {},
    NULL, direct8_mouseShow, direct8_mouseHide, direct8_mouseMove,
    direct8_plot, direct8_test, direct8_line, direct8_hline, direct8_vline,
    generic_box, generic_pbox, direct8_dvline, direct8_dhline, generic_dbox,
    generic_dpbox, generic_circ, generic_pcirc, direct8_bitblk,
    direct8_scroll, direct8_printc, direct8_prints, direct8_dplot,
    direct8_dline, generic_dcirc, generic_dpcirc, generic_poly,
    generic_dpoly, generic_ppoly, generic_dppoly,
    direct8_getblock, direct8_putblock
  }
};

unsigned char cmred[256],cmgreen[256],cmblue[256];

static struct grf_colormap my_map ={
0, 256, cmred, cmgreen, cmblue};



SCREEN *netbsd_amiga_init(void)
{
  int fh,i; 
  size_t size;
  caddr_t addr;
  volatile int yes = 1;
  volatile int vmode = GRF_VMODE;
  struct grfvideo_mode gv;
  char grfdev[10];

  if (!netbsd_grf_screen[NETBSD_GRF].mouseShow) {
    perror("grf not supported");
    return NULL;
  }

  sprintf(grfdev,"/dev/grf%d",NETBSD_GRF);
  if ((fh = open(grfdev, O_RDWR)) < 0) {
    perror("open()");
    return NULL;
  }

  /* Initialize colors 0-254 as white and 255 as black */
  for (i=0; i<255; i++)
    cmred[i] = cmgreen[i] = cmblue[i] = 0xff;
  cmred[255] = cmgreen[255] = cmblue[255] = 0;

  /* Init graphics */
  if (ioctl(fh, GRFSETVMODE, &vmode)) {
    perror("ioctl()");
    return NULL;
  }
  ioctl(fh, GRFIOCON, &yes);
  gv.mode_num = vmode;
  ioctl(fh, GRFGETVMODE, &gv);
  ioctl(fh, GRFIOCPUTCMAP, &my_map);

  printf("%d x %d pixels, %d bits per pixel\n",
	 gv.disp_width, gv.disp_height, gv.depth);

  size = (size_t)(gv.disp_width * gv.disp_height * gv.depth) >> 3;

  if ((addr = mmap(0, size,
		   PROT_READ | PROT_WRITE, MAP_SHARED,
		   fh, 65536)) == (caddr_t) -1) {
    perror("mmap()");
    close(fh);
    return NULL;
  }

  printf("%dK mapped to 0x%08x\n", size >> 10, (unsigned int)addr);

  sleep(2);

  netbsd_grf_screen[NETBSD_GRF].bm.width = gv.disp_width;
  netbsd_grf_screen[NETBSD_GRF].bm.height = gv.disp_height;
  netbsd_grf_screen[NETBSD_GRF].bm.type = BM_DIRECT8;
  netbsd_grf_screen[NETBSD_GRF].bm.unitsize = 1;
  netbsd_grf_screen[NETBSD_GRF].bm.upl = gv.disp_width;
  netbsd_grf_screen[NETBSD_GRF].bm.planes = gv.depth; /* should be 8 */
  netbsd_grf_screen[NETBSD_GRF].bm.data = (ushort *)addr;

  return &netbsd_grf_screen[NETBSD_GRF];
}

#endif
