/*
 * server/graph/init.c, part of W
 * (C) 94-01/96 TeSche (Torsten Scherer)
 * itschere@techfak.uni-bielefeld.de
 *
 * top level function for graphic initialization
 *
 * CHANGES:
 * - added support for NetBSD-Amiga, Phx 02/96
 */

#include <stdio.h>
#include "../../lib/Wlib.h"
#include "../config.h"
#include "../types.h"
#include "gproto.h"
#include "generic/generic.h"


/*
 * private (but not local to this file, thus no `static') variables
 */

SCREEN *theScreen;


/*
 * exported global variables
 */

REC *clip0, *clip1;
GCONTEXT *gc0;


/*
 *
 */

SCREEN *screen_init(void)
{
  /* root window pattern */
  static REC clip;
  static GCONTEXT gc;
  static ushort background[16] = {
    0xEEEE, 0xBBBB, 0xDDDD, 0x7777, 0xEEEE, 0xBBBB, 0xDDDD, 0x7777,
    0xEEEE, 0xBBBB, 0xDDDD, 0x7777, 0xEEEE, 0xBBBB, 0xDDDD, 0x7777
  };

#if defined(linux) || defined(__MINT__)
  theScreen = atari_init();
#elif defined(sun)
  theScreen = sun_init();
#elif defined(__NetBSD__)
  theScreen = netbsd_amiga_init();
#endif

  if (theScreen) {
    gc.pattern = background;
    clip.x0 = clip.y0 = 0;
    clip.x1 = (clip.w = theScreen->bm.width) - 1;
    clip.y1 = (clip.h = theScreen->bm.height) - 1;
    gc0 = &gc;
    clip0 = &clip;
    generic_dpbox (&theScreen->bm, 0, 0, theScreen->bm.width, theScreen->bm.height);
  }

  /* return whatever we've got */
  return theScreen;
}
