/*
 * server/graph/circle.c, part of W
 * (C) 94-02/96 by Torsten Scherer (TeSche)
 * itschere@techfak.uni-bielefeld.de
 *
 * routines dealing with circles
 *
 * CHANGES:
 *
 * - added patterned functions (untested). ++kay, 1/96
 * - added comments on how to speed things up. ++kay, 1/96
 */

#include <stdio.h>
#include "../../../lib/Wlib.h"
#include "../../config.h"
#include "../../types.h"
#include "../../pakets.h"
#include "../../proto.h"
#include "../gproto.h"
#include "../clip.h"
#include "generic.h"

/*
 *
 */

void generic_circ (bm, x0, y0, r)
     BITMAP *bm;
     register long x0;
     register long y0;
     long r;
{
  register void (*plot_fn) (BITMAP *, long, long);
  register long x, y, da;
  REC *oclip = clip0;

  plot_fn = theScreen->plot;

  if (!BOX_NEEDS_CLIPPING (x0-r-1, y0-r-1, r+r+2, r+r+2, clip0))
    clip0 = NULL;

  if (!r) {
    (*theScreen->plot)(bm, x0, y0);
    clip0 = oclip;
    return;
  }

  if (gc0->drawmode == M_INVERS) {
    (*plot_fn)(bm, x0-r, y0);
    (*plot_fn)(bm, x0+r, y0);
    (*plot_fn)(bm, x0, y0-r);
    (*plot_fn)(bm, x0, y0+r);
  }

  x = 0;
  y = r;
  da = r - 1;

  do {
    if (da < 0) {
      y--;
      da += y + y;
    }

    (*plot_fn)(bm, x0+x, y0+y);
    (*plot_fn)(bm, x0-x, y0+y);
    (*plot_fn)(bm, x0+x, y0-y);
    (*plot_fn)(bm, x0-x, y0-y);
    (*plot_fn)(bm, x0+y, y0+x);
    (*plot_fn)(bm, x0-y, y0+x);
    (*plot_fn)(bm, x0+y, y0-x);
    (*plot_fn)(bm, x0-y, y0-x);

    da = da - x - x - 1;
    x++;

  } while (x < y);

  if ((gc0->drawmode == M_INVERS) && (x != y)) {
    (*plot_fn)(bm, x0-y, y0-y);
    (*plot_fn)(bm, x0+y, y0-y);
    (*plot_fn)(bm, x0+y, y0+y);
    (*plot_fn)(bm, x0-y, y0+y);
  }
  clip0 = oclip;
}


void generic_pcirc (bm, x0, y0, r)
     BITMAP *bm;
     register long x0;
     register long y0;
     long r;
{
  register void (*hline_fn) (BITMAP *, long, long, long);
  register long dx, dy, rq = r * r;
  REC *oclip = clip0;

  hline_fn = theScreen->hline;

  if (!BOX_NEEDS_CLIPPING (x0-r-1, y0-r-1, r+r+2, r+r+2, clip0))
    clip0 = NULL;

  if (!r) {
    (*theScreen->plot)(bm, x0, y0);
    clip0 = oclip;
    return;
  }

  (*hline_fn)(bm, x0-r, y0, x0+r);

  dy = 0;
  dx = r;
  while (dx) {

    dy++;
    while (dx*dx + dy*dy > rq)
      dx--;

    (*hline_fn)(bm, x0-dx, y0-dy, x0+dx);
    (*hline_fn)(bm, x0-dx, y0+dy, x0+dx);
  }
  clip0 = oclip;
}


void generic_dcirc (bm, x0, y0, r)
     BITMAP *bm;
     register long x0;
     register long y0;
     register long r;
{
  register void (*dplot_fn) (BITMAP *, long, long);
  register long x, y, da;
  REC *oclip = clip0;

  dplot_fn = theScreen->dplot;

  if (!BOX_NEEDS_CLIPPING (x0-r-1, y0-r-1, r+r+2, r+r+2, clip0))
    clip0 = NULL;

  if (!r) {
    (*dplot_fn)(bm, x0, y0);
    clip0 = oclip;
    return;
  }

  x = 0;
  y = r;
  da = r - 1;

  do {
    if (da < 0) {
      y--;
      da += y + y;
    }

    (*dplot_fn)(bm, x0+x, y0+y);
    (*dplot_fn)(bm, x0-x, y0+y);
    (*dplot_fn)(bm, x0+x, y0-y);
    (*dplot_fn)(bm, x0-x, y0-y);
    (*dplot_fn)(bm, x0+y, y0+x);
    (*dplot_fn)(bm, x0-y, y0+x);
    (*dplot_fn)(bm, x0+y, y0-x);
    (*dplot_fn)(bm, x0-y, y0-x);

    da = da - x - x - 1;
    x++;

  } while (x < y);
  clip0 = oclip;
}


void generic_dpcirc (bm, x0, y0, r)
     BITMAP *bm;
     register long x0;
     register long y0;
     long r;
{
  register void (*dhline_fn) (BITMAP *, long, long, long);
  register long dx, dy, rq = r * r;
  REC *oclip = clip0;

  dhline_fn = theScreen->dhline;

  if (!BOX_NEEDS_CLIPPING (x0-r-1, y0-r-1, r+r+2, r+r+2, clip0))
    clip0 = NULL;

  if (!r) {
    (*theScreen->dplot)(bm, x0, y0);
    clip0 = oclip;
    return;
  }

  (*dhline_fn)(bm, x0-r, y0, x0+r);

  dy = 0;
  dx = r;
  while (dx) {

    dy++;
    while (dx*dx + dy*dy > rq)
      dx--;

    (*dhline_fn)(bm, x0-dx, y0-dy, x0+dx);
    (*dhline_fn)(bm, x0-dx, y0+dy, x0+dx);
  }
  clip0 = oclip;
}
