/*
 * server/graph/direct8/direct8_block.c, part of W
 * (C) 94-02/96 by Torsten Scherer (TeSche)
 * itschere@techfak.uni-bielefeld.de
 *
 * getblock/putblock routines for the DIRECT8 driver
 */

#include <stdio.h>
#include <stdlib.h>
#include "../../../lib/Wlib.h"
#include "../../config.h"
#include "../../types.h"
#include "../../pakets.h"
#include "../../proto.h"
#include "../clip.h"
#include "direct8.h"


/*
 *
 */

inline void d2pm(register uchar *slptr,
		 register ulong *dlptr,
		 register short width)
{
  register ulong dlbit = 0x80000000;
  register ulong dval = *dlptr;

  while (--width >= 0) {
    if (*slptr++) {
      dval |= dlbit;
    } else {
      dval &= ~dlbit;
    }
    if (!(dlbit >>= 1)) {
      *dlptr++ = dval;
      dlbit = 0x80000000;
      dval = *dlptr;
    }
  }
  *dlptr = dval;
}


BITMAP *direct8_getblock(BITMAP *bm,
			 short x0,
			 short y0,
			 register short width,
			 register short height)
{
  BITMAP *ret;
  register uchar *sptr;
  register ulong *dptr;
  register long sbpl, dlpl;

  if ((width < 1) || (height < 1)) {
    return NULL;
  }

  if (!(ret = malloc (sizeof (BITMAP)))) {
    return NULL;
  }

  ret->width = (width + 31) & ~31;
  ret->height = height;
  ret->type = BM_PACKEDMONO;
  ret->unitsize = 4;
  ret->upl = ret->width >> 5;
  ret->planes = 1;
  if (!(ret->data = malloc (ret->unitsize * ret->upl * ret->height))) {
    free(ret);
    return NULL;
  }

  sbpl = bm->upl;
  sptr = (uchar *)bm->data + y0 * sbpl + x0;

  dptr = (ulong *)ret->data;
  dlpl = ret->upl;

  while (--height >= 0) {
    d2pm(sptr, dptr, width);
    sptr += sbpl;
    dptr += dlpl;
  }

  return ret;
}


inline void pm2d(register ulong *sptr,
		 register ulong sbit,
		 register uchar *dptr,
		 register short width)
{
  register ulong sval = *sptr;

  while (--width >= 0) {
    if (sval & sbit) {
      *dptr++= 0xff;
    } else {
      *dptr++= 0x00;
    }
    if (!(sbit >>= 1)) {
      sbit = 0x80000000;
      sval = *++sptr;
    }
  }
}


void direct8_putblock(BITMAP *bm0,
		      short x0,
		      short y0,
		      register short width,
		      register short height,
		      BITMAP *bm1,
		      short x1,
		      short y1)
{
  register uchar *dptr;
  register ulong *sptr, sbit;
  register long slpl, dbpl;

  if ((width < 1) || (height < 1)) {
    return;
  }

  /* bm0 is the BM_PACKEDMONO bitmap we copy from, but bm1 is BM_DIRECT8
   */

  slpl = bm0->upl;
  sptr = (ulong *)bm0->data + y0 * slpl + (x0 >> 5);
  sbit = 0x80000000 >> (x0 & 31);

  dbpl = bm1->upl;
  dptr = (uchar *)bm1->data + y1 * dbpl + x1;

  while (--height >= 0) {
    pm2d(sptr, sbit, dptr, width);
    sptr += slpl;
    dptr += dbpl;
  }
}
