/*
 * font.c, part of W
 * (C) 94-12/95 by Torsten Scherer (TeSche)
 * itschere@techfak.uni-bielefeld.de
 */

#include <fcntl.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>

#include "wserver.h"


FONT glob_font[MAXFONTS];


/*
 * some private functions
 */

int load_font(int font_h, char *fname)
{
  long fh, i, longs, needs;
  char buf[81];

#ifdef FONTDIR
  sprintf(buf, "%s/%s", FONTDIR, fname);
#else
#error you must define FONTDIR!!!
#endif
  if ((fh = open(buf, O_RDONLY)) < 0) {
    return -1;
  }

  if (read(fh, &glob_font[font_h].hdr, sizeof(FONTHDR)) != sizeof(FONTHDR)) {
    close(fh);
    return -2;
  }

  /* WFNT? */
  if (glob_font[font_h].hdr.magic != 0x57464E54) {
    close(fh);
    return -3;
  }

  glob_font[font_h].name = strdup(fname);

  longs = 0;
  for (i=0; i<256; i++) {
    glob_font[font_h].offsets[i] = longs;
    longs += ((glob_font[font_h].hdr.widths[i] * glob_font[font_h].hdr.height + 31) & ~31) >> 5;
  }

  needs = longs << 2;
  if (!(glob_font[font_h].data = malloc(needs))) {
    close(fh);
    return -4;
  }

  if (read(fh, glob_font[font_h].data, needs) != needs) {
    close(fh);
    free(glob_font[font_h].data);
    return -5;
  }

  glob_font[font_h].numused = 1;
  close(fh);

  return font_h;
}


/*
 * the exported functions
 */

int font_init(void)
{
  int i, err1, err2;

  for (i=0; i<MAXFONTS; i++) {
    glob_font[i].numused = 0;
  }

  err1 = load_font(0, "fixed8.wfnt");
  err2 = load_font(1, "lucidat12.wfnt");

  if ((err1 < 0) || (err2 < 0)) {
    fprintf(stderr, "fatal: font initialisation error\r\n");
    return -1;
  }

  return 0;
}


short font_loadfont(char *fontname)
{
  short i, fglobh;

  fglobh = -1;
  for (i=0; i<MAXFONTS; i++) {
    if (!glob_font[i].numused) {
      fglobh = i;
      break;
    }
  }

  if (fglobh == -1) {
    return -1;
  }

  return load_font(fglobh, fontname);
}


short font_unloadfont(FONT *fp)
{
  if (fp->numused > 0) {
    return -1;
  }

  fp->numused = 0;
  free(fp->data);

  return 0;
}


/*
 * calculate the length of a string in pixel
 */

int fontStrLen(FONT *f, char *s)
{
  int len = 0;

  while (*s) {
    /*
     * kay: I have those sign extension bugs!
     */
    len += f->hdr.widths[*s++ & 0xff];
  }

  return len;
}
