/*
 * server/client_block.c, part of W
 * (C) 94-02/96 by Torsten Scherer (TeSche)
 * itschere@techfak.uni-bielefeld.de
 *
 * these routines implement w_getblock and w_putblock. they are a bit more
 * difficult as data comes in seperate chunks. some of them return something,
 * others not.
 */

#include <stdio.h>
#include <sys/time.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#ifdef __MINT__
# include <mintbind.h>
#endif
#include <string.h>
#include <stdlib.h>

#include "../lib/Wlib.h"
#include "config.h"
#include "types.h"
#include "pakets.h"
#include "proto.h"

#include "window.h"
#include "rect.h"

#define BLOCK_NONE 0
#define BLOCK_GET 1
#define BLOCK_PUT 2


/*
 * client_putblock() and friends
 */

static void putblock(CLIENT *cptr)
{
  WINDOW *win;
  REC clip;
  short x0, y0, width, height, x1, y1;

  if (!(win = windowLookup(cptr->bwin))) {
    return;
  }

  x0 = cptr->bx0;
  y0 = cptr->by0;
  width = cptr->bwidth;
  height = cptr->bheight;
  x1 = cptr->bx1;
  y1 = cptr->by1;

  clip.x0 = clip.y0 = 0;
  clip.x1 = (clip.w = cptr->bwidth) - 1;
  clip.y1 = (clip.h = cptr->bheight) - 1;
  clip0 = &clip;

  x1 += win->area[AREA_WORK].x0;
  y1 += win->area[AREA_WORK].y0;

#ifdef REFRESH
  if (42) {
#else
  if (!win->is_open || win->is_hidden) {
#endif
    clip1 = &win->area[AREA_WORK];
    (*glob_screen->putblock)(cptr->bbm, x0, y0, width, height,
			     &win->bitmap, x1, y1);
    if (win->is_open) {
      if (mouse_rcintersect(win->pos.x0 + x1,
			    win->pos.y0 + y1, width, height)) {
	mouse_hide();
      }
      rectUpdateDirty(&win->dirty, x1, y1, width, height);
    }
  } else {
    if (mouse_rcintersect(win->pos.x0 + x1, win->pos.y0 + y1,
			  width, height)) {
      mouse_hide();
    }
    clip1 = &win->work;
    (*glob_screen->putblock)(cptr->bbm, x0, y0, width, height,
			     &glob_screen->bm, win->pos.x0+x1, win->pos.y0+y1);
    win->is_dirty = 1;
  }
}


short client_putblockreq(CLIENT *cptr,
			 short rwidth, short rheight,
			 short x0, short y0,
			 short width, short height,
			 ushort handle, short x1, short y1)
{
  WINDOW *win;
  long size;

  /* do some checks first, they're worth it as
   * they might save us a lot of data transfer
   */
  if (cptr->btype || (rwidth < 0) || (rheight < 0) || (width < 0) ||
      (height < 0) || (x0 < 0) || (y0 < 0) || (x1 < 0) || (y1 < 0)) {
    return -1;
  }

  if (!(win = windowLookup(handle))) {
    return -1;
  }

  if (win->flags & W_CONTAINER) {
    return -1;
  }

  /* data should come long-aligned */
  if (rwidth & 31) {
    return -1;
  }

  if ((x0 + width > rwidth) || (y0 + height > rheight) ||
      (x1 + width > win->area[AREA_WORK].w) ||
      (y1 + height > win->area[AREA_WORK].h)) {
    return -2;
  }

  /* allocate a temporary bitmap
   */
  if (!(cptr->bbm = malloc (sizeof (BITMAP)))) {
    return -3;
  }
  size = (rwidth >> 3) * rheight;
  if (!(cptr->bbm->data = malloc (size))) {
    free(cptr->bbm);
    cptr->bbm = NULL;
    return -4;
  }

  /* looks like we can do it
   */
  cptr->btype = BLOCK_PUT;
  cptr->bsize = size;
  cptr->boffset = 0;
  cptr->bbm->width = rwidth;
  cptr->bbm->height = rheight;
  cptr->bbm->type = BM_PACKEDMONO;
  cptr->bbm->unitsize = 4;
  cptr->bbm->upl = rwidth >> 5;
  cptr->bbm->planes = 1;

  cptr->bx0 = x0;
  cptr->by0 = y0;
  cptr->bwidth = width;
  cptr->bheight = height;
  cptr->bwin = handle;
  cptr->bx1 = x1;
  cptr->by1 = y1;

  return 0;
}


void client_putblockdata(CLIENT *cptr, PAKET *rawdata)
{
  long todo;

  if (cptr->btype != BLOCK_PUT) {
    return;
  }

  todo = cptr->bsize - cptr->boffset;
  if (rawdata->len - 4 < todo) {
    todo = rawdata->len - 4;
  }

  memcpy(cptr->bbm->data + cptr->boffset, rawdata->data, todo);

  if ((cptr->boffset += todo) >= cptr->bsize) {
    putblock(cptr);
    free(cptr->bbm->data);
    free(cptr->bbm);
    cptr->bbm = NULL;
    cptr->btype = BLOCK_NONE;
  }
}


/*
 * client_getblock() and friends
 */

static BITMAP *getblock(CLIENT *cptr,
			ushort handle,
			short x0, short y0,
			short width, short height)
{
  WINDOW *win;
  REC clip;
  BITMAP *ret;

  if (!(win = windowLookup(handle))) {
    return NULL;
  }

  clip.x0 = clip.y0 = 0;
  clip.x1 = (clip.w = width) - 1;
  clip.y1 = (clip.h = height) - 1;
  clip0 = &clip;

  x0 += win->area[AREA_WORK].x0;
  y0 += win->area[AREA_WORK].y0;

#ifdef REFRESH
  if (42) {
#else
  if (!win->is_open || win->is_hidden) {
#endif
    clip1 = &win->area[AREA_WORK];
    ret = (*glob_screen->getblock)(&win->bitmap, x0, y0, width, height);
  } else {
    if (mouse_rcintersect(win->pos.x0 + x0, win->pos.y0 + y0,
			  width, height)) {
      mouse_hide();
    }
    clip1 = &win->work;
    ret = (*glob_screen->getblock)(&glob_screen->bm, win->pos.x0 + x0,
				   win->pos.y0 + y0, width, height);
  }

  return ret;
}


long client_getblockreq(CLIENT *cptr, ushort handle,
			short x0, short y0, short width, short height)
{
  WINDOW *win;

  if (cptr->btype || (width < 0) || (height < 0) || (x0 < 0) || (y0 < 0)) {
    return -1;
  }

  if (!(win = windowLookup(handle))) {
    return -2;
  }

  if (win->flags & W_CONTAINER) {
    return -3;
  }

  if ((x0 + width > win->area[AREA_WORK].w) ||
      (y0 + height > win->area[AREA_WORK].h)) {
    return -4;
  }

  if (!(cptr->bbm = getblock(cptr, handle, x0, y0, width, height))) {
    return -5;
  }

  cptr->btype = BLOCK_GET;
  cptr->boffset = 0;
  return (cptr->bsize = cptr->bbm->unitsize * cptr->bbm->upl * cptr->bbm->height);
}


void client_getblockdata(CLIENT *cptr, PAKET *rawdata)
{
  long todo;

  if (cptr->btype != BLOCK_GET) {
    return;
  }

  todo = cptr->bsize - cptr->boffset;
  if (todo > rawdata->len - 4) {
    todo = rawdata->len - 4;
  }

  memcpy(rawdata->data, cptr->bbm->data + cptr->boffset, todo);

  if ((cptr->boffset += todo) >= cptr->bsize) {
    free(cptr->bbm->data);
    free(cptr->bbm);
    cptr->bbm = NULL;
    cptr->btype = BLOCK_NONE;
  }
}
