/*
 * programs/wstatus.c, part of W
 * (C) 95-02/96 by Torsten Scherer (TeSche)
 * itschere@techfak.uni-bielefeld.de
 */

#include <stdio.h>
#include <sys/types.h>
#include <arpa/inet.h>
#include <netinet/in.h>
#include <Wlib.h>


int main(void)
{
  short i;
  STATUS st;
  struct in_addr iadr;
  WSERVER *wserver;

  if (!(wserver = w_init())) {
    fprintf(stderr, "error: can't connect to wserver\n");
    return -1;
  }

  printf("this is W%iR%i, ", wserver->vmaj, wserver->vmin);
  printf("running on a %i*%i screen with %li colors\n", wserver->width, wserver->height, wserver->colors);

  if ((i = w_querystatus(&st, -1)) < 0) {
    fprintf(stderr, "error: w_querystatus failed\n");
    return -1;
  }

  printf("there're currently %i clients running (including me)\n", i);
  printf("server statistic:\n");
  printf("%li pakets processed, %li bytes received\n", st.pakets, st.bytes);
  printf("%i windows open, %i windows total in use\n", st.openWin, st.totalWin);

  printf("client statistic:\n");

  i = 0;
  while (42) {

    if (w_querystatus(&st, i) < 0) {
      return 0;
    }

    if (!st.ip_addr) {
      printf("%2i (local): %i/%i windows, %li pakets / %li bytes received\n",
	     i+1, st.openWin, st.totalWin, st.pakets, st.bytes);
    } else {
      iadr.s_addr = st.ip_addr;
      printf("%2i (%s): %i/%i windows, %li pakets / %li bytes received\n",
	     i+1, inet_ntoa(iadr), st.openWin, st.totalWin, st.pakets, st.bytes);
    }

    i++;
  }
}
