/*
 * programs/wsetbg.c, part of W
 * (C) 94-02/96 by Torsten Scherer (TeSche)
 * itschere@techfak.uni-bielefeld.de
 *
 * changed for W1R2 by TeSche 01-11/95
 * w_readimg() moved into Wlib, TeSche 01/96
 */

#include <stdio.h>
#include <stdlib.h>
#include <Wlib.h>


/*
 * guess what...
 */

void main(long argc, char *argv[])
{
  short dwidth, dheight, swidth, sheight, cwidth, cheight;
  short cdx, cdy, csx, csy;
  BITMAP *bmtmp;
  WSERVER *wserver;

  if (argc != 2) {
    fprintf(stderr, "usage: wsetbg <filename>\n");
    exit(-1);
  }

  if (!(wserver = w_init())) {
    fprintf(stderr, "error: can't connect to w server\n");
    exit(-1);
  }

  dwidth = wserver->width;
  dheight = wserver->height;

  if (!(bmtmp = w_readimg(argv[1], &swidth, &sheight))) {
    exit(-1);
  }

  /* clip at x-axis? */
  if (swidth > dwidth) {
    cwidth = dwidth;
    cdx = 0;
    csx = (swidth - dwidth) >> 1;
  } else {
    cwidth = swidth;
    cdx = (dwidth - swidth) >> 1;
    csx = 0;
  }

  /* clip at y-axis? */
  if (sheight > dheight) {
    cheight = dheight;
    cdy = 0;
    csy = (sheight - dheight) >> 1;
  } else {
    cheight = sheight;
    cdy = (dheight - sheight) >> 1;
    csy = 0;
  }

  w_putblock(bmtmp, csx, csy, cwidth, cheight, WROOT, cdx, cdy);
  w_flush();

  free(bmtmp->data);
  free(bmtmp);
}
