/*
 * programs/wsaver1.c, part of wsaver, part of W
 * (C) 94-02/96 by Torsten Scherer (TeSche)
 * (itschere@techfak.uni-bielefeld.de)
 *
 * a sample wsaver module
 */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <Wlib.h>


#define	MAXLINES 100


typedef struct {
  short	x0, y0, xe, ye;
} LINE;


static LINE line[MAXLINES];
static short idx;
static short x0, y0, xe, ye;
static short dx0, dy0, dxe, dye;


extern WWIN *win;
extern short swidth, sheight;


static void movelines(void)
{
  /* delete the old line */
  w_setmode(win, M_DRAW);
  w_line(win, line[idx].x0, line[idx].y0, line[idx].xe, line[idx].ye);

  /* calculate new pos */
  x0 += dx0;
  if (x0 < 0) {
    x0 = -x0;
    dx0 = (random() & 7 ) + 1;
  }
  if (x0 >= swidth) {
    x0 = 2 * swidth - x0 - 1;
    dx0 = - (random() & 7) - 1;
  }

  y0 += dy0;
  if (y0 < 0) {
    y0 = -y0;
    dy0 = (random() & 7) + 1;
  }
  if (y0 >= sheight) {
    y0 = 2 * sheight - y0 - 1;
    dy0 = - (random() & 7) - 1;
  }

  xe += dxe;
  if (xe < 0) {
    xe = -xe;
    dxe = (random() & 7) + 1;
  }
  if (xe >= swidth) {
    xe = 2 * swidth - xe - 1;
    dxe = - (random() & 7) - 1;
  }

  ye += dye;
  if (ye < 0) {
    ye = -ye;
    dye = (random() & 7) + 1;
  }
  if (ye >= sheight) {
    ye = 2 * sheight - ye - 1;
    dye = - (random() & 7) - 1;
  }

  /* then draw new line */
  line[idx].x0 = x0;
  line[idx].y0 = y0;
  line[idx].xe = xe;
  line[idx].ye = ye;
  w_setmode(win, M_CLEAR);
  w_line(win, line[idx].x0, line[idx].y0, line[idx].xe, line[idx].ye);

  if (++idx == MAXLINES) {
    idx = 0;
  }
}


void wsaver1(void)
{
  short end, i;
  WEVENT *ev;

  if (!(win = w_create(swidth, sheight, W_TOP | W_NOBORDER | W_NOMOUSE))) {
    /* sorry, can't help myself */
    return;
  }

  w_setmode(win, M_DRAW);
  w_pbox(win, 0, 0, swidth, sheight);
  w_open(win, 0, 0);

  idx = 0;
  x0 = (xe = (swidth >> 1));
  y0 = (ye = (sheight >> 1));

  w_setmode(win, M_CLEAR);
  for (i=0; i<MAXLINES; i++) {
    line[i].x0 = x0;
    line[i].y0 = y0;
    line[i].xe = xe;
    line[i].ye = ye;
    w_line(win, line[i].x0, line[i].y0, line[i].xe, line[i].ye);
  }

  dx0 = (random() & 7) + 1;
  if (random() & 1) dx0 = -dx0;
  dy0 = (random() & 7) + 1;
  if (random() & 1) dy0 = -dy0;
  dxe = (random() & 7) + 1;
  if (random() & 1) dxe = -dxe;
  dye = (random() & 7) + 1;
  if (random() & 1) dye = -dye;

  end = 0;
  while (!end) {

    if ((ev = w_queryevent(NULL, NULL, NULL, 100))) switch (ev->type) {

    case EVENT_GADGET:
      if (ev->key == GADGET_EXIT) {
	w_delete(win);
	w_exit();
	exit(0);
      }
      break;

    case EVENT_SAVEOFF:
      end = 1;
    }

    movelines();
  }

  w_delete(win);
}
