/*
 * programs/wsaver.c, part of W
 * (C) 94-02/96 by Torsten Scherer (TeSche)
 * (itschere@techfak.uni-bielefeld.de)
 *
 *  a simple screen saver
 */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/time.h>
#include <Wlib.h>


extern void wsaver1(void);
extern void wsaver2(void);


WWIN *win;
short swidth, sheight;


static void usage()
{
  fprintf(stderr, "usage: wsaver <seconds>\n");
  fprintf(stderr, "       where seconds > 10\n");
}

void main(int argc, char *argv[])
{
  short seconds;
  WEVENT *ev;
  WSERVER *wserver;

  if (argc != 2) {
    usage();
    exit(-1);
  }

  if ((seconds = atoi(argv[1])) < 10) {
    fprintf(stderr, "error: timeout must be greater than 10 seconds.\n");
    exit(-1);
  }

  if (!(wserver = w_init())) {
    fprintf(stderr, "error: can't connect to wserver\n");
    exit(-1);
  }

  swidth = wserver->width;
  sheight = wserver->height;

  if (w_setsaver(seconds) < 0) {
    fprintf(stderr,
	    "error: can't install screensaver, already one running?\n");
    exit(-1);
  }

  srandom(time(0));

  while (42) {

    if ((ev = w_queryevent(NULL, NULL, NULL, -1))) {

      switch (ev->type) {

        case EVENT_GADGET:
	  if (ev->key == GADGET_EXIT) {
	    exit(0);
	  }
	  break;

	case EVENT_SAVEON:
	  if ((random() & 7) < 4) {
	    wsaver1();
	  } else {
	    wsaver2();
	  }
	  break;
      }
    }
  }
}
