/*
     wload - client for W
     (c) 9/94 by Benjamin Lorenz

     Version 1.0, last update Sep 10 1994

             1.0a, Sep 30 1994 TeSche: small bugfix: scale lines were drawn
		   one pixel too long, fixing this involved more changes in
		   when to bitblk and so on... :(

	     1.0b, Oct 6 1994 TeSche: okok, another small bugfix, as
		   suggested by Benni

	     1.0c, Dec 11 1994 TeSche: changed for W1R0

	     1.1, Mar 26 1995 TeSche: added support for Linux68k

	     1.2, Dec 02 1995 TeSche: major rewrite

	     1.2a, Feb 11 1996 TeSche: YAABF :)
*/

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>

#include <Wlib.h>

#define LFRACTION 2048


#ifdef __MINT__

#include <macros.h>
#include <support.h>
#include <mintbind.h>


#elif linux


#define max(a,b) (((a) > (b)) ? (a) : (b))

void Suptime(ulong *uptime, ulong *load)
{
  FILE *fp = NULL;
  float f1, f2, f3;

  /* sorry, can't make this static 'cause Linux can't rewind this file
   */
  if (!(fp = fopen("/proc/loadavg", "r"))) {
    fprintf(stderr, "error: can't open /proc/loadavg\n");
    exit(-1);
  }

  fscanf(fp, "%f %f %f\n", &f1, &f2, &f3);

  *uptime = 0; /* we don't need that */
  load[0] = f1 * LFRACTION;
  load[1] = f2 * LFRACTION;
  load[2] = f3 * LFRACTION;
}

#else

void Suptime(ulong *uptime, ulong *load)
{
  *uptime = 1;
  load[0] = 1;
  load[1] = 1;
  load[2] = 1;
}

#endif


/*
 * global variables
 */

#define winw 80
#define winh 128
#define header 13

static WWIN *win;
static int loads[winw];


/*
 *
 */

static void w_clear()
{
  w_setmode(win, M_CLEAR);
  w_pbox(win, 0, header, winw, winh - header);
}


static void print_load(int l)
{
  static int x = 0, lceil_old = 1;
  int i, lceil;

  /* insert new load value */
  if (x == winw) {
    for (i=0; i<winw-1; i++) {
      loads[i] = loads[i+1];
    }
    loads[winw - 1] = l;
  } else {
    loads[x] = l;
  }

  /* calc new ceil() value of loads */
  lceil = 0;
  for (i=0; i<winw; i++) {
    if (loads[i] > lceil) {
      lceil = loads[i];
    }
  }
  if ((lceil = (lceil + LFRACTION - 1) / LFRACTION) == 0) {
    lceil = 1;
  }

  if (lceil != lceil_old) {

    /* completely redraw window */
    w_clear();
    w_setmode(win, M_DRAW);
    for (i=0; i<winw; i++) {
      w_vline(win, i, winh - 1, winh - 1 - (loads[i] * (winh - header)) / (lceil * LFRACTION));
    }
    w_setmode(win, M_INVERS);
    for (i=1; i<lceil; i++) {
      w_hline(win, 0, winh - 1 - (i * (winh - header)) / lceil, winw-1);
    }

    if (x == winw) {
      x--;
    }

  } else {

    if (x >= winw) {
      w_bitblk(win, 1, header, winw-1, winh-header, 0, header);
      x--;
    }

    w_setmode(win, M_CLEAR);
    w_vline(win, x, header, winh-1);
    w_setmode(win, M_DRAW);
    w_vline(win, x, winh - 1, winh - 1 - (loads[x] * (winh - header)) / (lceil * LFRACTION));
    w_setmode(win, M_INVERS);
    for (i=1; i<lceil; i++) {
      w_plot(win, x, winh - 1 - (i * (winh - header)) / lceil);
    }
  }

  lceil_old = lceil;
  x++;
}


static void usage(char *s)
{
  if (s) {
    fprintf(stderr, "%s\n", s);
  }
  fprintf(stderr, "Usage: wload [-h] [-u seconds] [-g <geometry>]\n");
  exit(1);
}


int main(int argc, char **argv)
{
#if defined(__MINT__) || defined(linux)
  int i, l, u = 10;
  unsigned long uptime;
  unsigned long load[3];
  unsigned long avg[3];
  char hostname[16], *geo = NULL;
  WEVENT *ev;
  short ew, eh, xp, yp;
  WSERVER *wserver;

  /* skip program name */
  argv++;

  while (*argv && **argv=='-') switch (*(*argv+1)) {

    case 'g':
      if (*++argv) {
	geo = *argv++;
      } else {
	usage("option `-g' requires an argument");
      }
      break;

    case 'h':
      /* this will never return */
      usage(NULL);

    case 'u':
      if (*++argv) {
	if ((u = atoi(*argv++)) < 1) {
	  u = 1;
	}
	if (u > 60) {
	  u = 60;
	}
      } else {
	usage("option `-u' requires an argument");
      }
      break;

    default:
      usage("unknown option");
  }

  if (!(wserver = w_init())) {
    fprintf(stderr, "error: can't connect to wserver\n");
    exit(1);
  }

  if (!(win = w_create(winw, winh, W_MOVE))) {
    fprintf(stderr, "error: can't create window\n");
    exit(1);
  }

  xp = -32768;
  yp = -32768;
  if (geo) {
    scan_geometry(geo, NULL, NULL, &xp, &yp);
  }

  w_querywinsize(win, 1, &ew, &eh);

  if ((xp != -32768) && (yp != -32768)) {
    if (xp < 0) {
      xp = wserver->width - ew - xp;
    }
    if (yp < 0) {
      yp = wserver->height - eh - yp;
    }
  } else {
    xp = UNDEF;
    yp = UNDEF;
  }

  if (w_open(win, xp, yp)) {
    w_delete(win);
    fprintf(stderr, "error: can't open window\n");
    exit(1);
  }

  gethostname(hostname, 16);

  for (i = 0; i < 3; i++)
    avg[i]=0;
  for (i = 0; i < winw; i++)
    loads[i] = 0.0;

  w_setmode(win, M_DRAW);
  w_setfont(win, w_loadfont("cour10b.wfnt"));
  w_printstring(win, 1, 1, hostname);
  w_line(win, 0, winh - 1, winw - 1, winh - 1);

  while (1) {
    Suptime(&uptime, load);
    avg[0] = avg[1];
    avg[1] = avg[2];
    avg[2] = load[0];

    /* calc load in 1/LFRACTION fractions  */
    l = (avg[0] + avg[1] + avg[2]) / 3;
    print_load(l);

    /* TeSche: watch out for `exit' event */
    if ((ev = w_queryevent(NULL, NULL, NULL, 1000 * u))) {
      if ((ev->type == EVENT_GADGET) && (ev->key == GADGET_EXIT)) {
	w_delete(win);
	exit(0);
      }
    }
  }
#endif
}
