/*
 * programs/wfontdemo.c, part of W
 * (C) 94-02/96 by Torsten Scherer (TeSche)
 * itschere@techfak.uni-bielefeld.de
 *
 * CHANGES:
 *
 * - lots and many, TeSche
 */

#include <stdio.h>
#include <dirent.h>
#include <unistd.h>
#include <Wlib.h>


#define WIDTH 600
#define HEIGHT 350


WWIN *getwindow(short width, short height)
{
  WSERVER *wserver;
  WWIN *win;

  if (!(wserver = w_init())) {
    return NULL;
  }

  if (!(win = w_create(width, height, W_MOVE | W_TITLE | EV_KEYS | EV_MOUSE))) {
    return NULL;
  }

  w_settitle(win, " wfontdemo ");

  if (w_open(win, UNDEF, UNDEF) < 0) {
    w_delete(win);
    return NULL;
  }

  return win;
}


int main(void)
{
  WWIN *win;
  DIR *dp;
  struct dirent *dentry;
  char msg[80];
  WFONT *font;
  WEVENT *ev;

  if (!(win = getwindow(WIDTH, HEIGHT))) {
    fprintf(stderr, "error: can't open window\n");
    exit(-1);
  }

  w_setmode(win, M_CLEAR);

  if ((dp = opendir(FONTDIR))) {

    /* skip `.' and `..' */
    readdir(dp);
    readdir(dp);

    while ((dentry = readdir(dp))) {
      if ((font = w_loadfont(dentry->d_name))) {
	w_setfont(win, font);
	w_vscroll(win, 0, font->height, WIDTH, HEIGHT - font->height, 0);
	w_pbox(win, 0, HEIGHT - font->height - 1, WIDTH, font->height);
	w_setfont(win, font);
	sprintf(msg, "%s: Fontdemo ~123@#", dentry->d_name);
	w_printstring(win, 0, HEIGHT - font->height - 1, msg);
	w_unloadfont(font);

	if ((ev = w_queryevent(NULL, NULL, NULL, 1000))) {
	  if ((ev->type == EVENT_GADGET) &&
	      ((ev->key == GADGET_EXIT) || (ev->key == GADGET_CLOSE))) {
	    return -1;
	  }
	}
      }
    }

    closedir(dp);
  }

  w_settitle(win, " wfontdemo - click anywhere to dismiss ");

  w_queryevent(NULL, NULL, NULL, -1);
  w_delete(win);

  return 0;
}
