/*
 * programs/cpyrgt.c, part of W
 * (C) 94-02/96 by Torsten Scherer (TeSche)
 * itschere@techfak.uni-bielfeld.de
 */

#include <stdio.h>
#include <Wlib.h>

/* so that it will fit even on the smallest screen... */
#define WIDTH 312
#define HEIGHT 192


/*
 * a picture...
 */

static ulong picData[] = {
0x000003bb, 0x800003ff, 0xbc000000,
0x00001f55, 0x3c003d55, 0x55700000,
0x00007fef, 0xef01ffef, 0xeff80000,
0x0000f555, 0x551d5555, 0x555c0000,
0x0001faba, 0xbbfbbbba, 0x9bbe0000,
0x0003d555, 0x55555555, 0x55570000,
0x0003eeea, 0xeefeeeea, 0xeeef8000,
0x00075555, 0x35555555, 0x15558000,
0x0007aaaa, 0xbbaaaaaa, 0xaaab8000,
0x00055555, 0x55555555, 0x55558000,
0x000feffe, 0xeeffaaab, 0xfeaf8000,
0x000d5ffd, 0x55ffd117, 0xff158000,
0x000ebffe, 0xaaffeaab, 0xffabc000,
0x000d5ffc, 0x55ffe445, 0xffd5c000,
0x000ebffe, 0xeaffeaae, 0xffab8000,
0x000d1ffc, 0x117fe005, 0x7f970000,
0x000aaffe, 0x2affea2a, 0xbfae8000,
0x000d47fc, 0x047fe005, 0x7f850000,
0x000eabfe, 0xaabfea8a, 0xffaa0000,
0x000d13ff, 0x005fe001, 0x5f970000,
0x000aabfe, 0x2abff22a, 0xbfab0000,
0x000d4fff, 0x004ff005, 0x5f970000,
0x000ebbfe, 0x2aaff88a, 0xffef0000,
0x000d15ff, 0x001ff007, 0xdf978000,
0x000abbfe, 0x82aff8ff, 0xbfab8000,
0x000d34ff, 0x0017fff5, 0x5fc78000,
0x000eaeff, 0x882fbfee, 0xefab8000,
0x000d54ff, 0x0015f555, 0x5f978000,
0x000afaff, 0x802ffaaa, 0xbfab8000,
0x000c54ff, 0xc03ffd55, 0x5fc78000,
0x000eeaff, 0x81fffeaa, 0xafaa8000,
0x0005d17f, 0x87d7fd11, 0x1f070000,
0x0006aaff, 0x8fabfeaa, 0xaf2b8000,
0x0005d43f, 0xc557ff44, 0x1f070000,
0x0007eabf, 0xeeabfeaa, 0xafae8000,
0x0005503f, 0xd551ff00, 0x1f054000,
0x0003aabf, 0xeaabffaa, 0x2e2ec000,
0x0001541f, 0xe557ff00, 0x0e054000,
0x0003eabf, 0xeaabffa8, 0xbe2ac000,
0x0003505f, 0xe103ff80, 0x1c194000,
0x0001abaf, 0xeaabffa0, 0x3e2bc000,
0x0001575f, 0xf407ffc0, 0x3c054000,
0x0001eeef, 0xf2afffc0, 0x383ac000,
0x00015d57, 0xf8077fc0, 0x78014000,
0x0000aaaf, 0xfa3effc0, 0x782ac000,
0x00005557, 0xfc1d7fe0, 0xf4614000,
0x00007eab, 0xfcbeffe0, 0xe82ac000,
0x00005503, 0xfe757ff1, 0xd0414000,
0x00006aab, 0xfffabff7, 0xa862c000,
0x0000d543, 0xfff55fff, 0xc0c14000,
0x0000eaa9, 0xffeabfff, 0xa18a4000,
0x0001d101, 0xffd01fff, 0x03018000,
0x0001aaa3, 0xffaabffe, 0xa2828000,
0x00015400, 0xff545ffd, 0x44048000,
0x0003eaa8, 0xfeaaaffa, 0xaa0a8000,
0x00035000, 0x75101fd5, 0x11018000,
0x0003aa20, 0x7aaa2faa, 0xaa0b8000,
0x00034400, 0x15400554, 0x54070000,
0x0003ea80, 0x2aa82eaa, 0xe80b0000,
0x00019000, 0x11000551, 0x50060000,
0x0001ea00, 0x2aa02aae, 0xa80e0000,
0x0000e000, 0x14000455, 0x400e0000,
0x0000f800, 0x0aa00aea, 0xa8180000,
0x00007c00, 0x10000155, 0x00380000,
0x00003fc0, 0x0a001bae, 0xa0f80000,
0x00001ffc, 0x0007d545, 0xffc00000,
0x00002fef, 0xffefeaae, 0xfea00000,
0x00001555, 0x55555105, 0x55500000,
0x00000aaa, 0xaa8aaaaa, 0xaaa00000,
0x00000455, 0x55514444, 0x54400000,
0x000002aa, 0xaaaaaaaa, 0xaa800000,
0x00000001, 0x01000001, 0x00000000,
0x0000002a, 0xaaaa220a, 0xaa000000};


/*
 * what we've going to export...
 */

int main (int argc, char *argv[])
{
  short ewidth, eheight, x, y, i;
  WSERVER *wserver;
  WWIN *win;
  WFONT *tiny, *small, *medium, *big;
  WEVENT *event;
  BITMAP grafik = {96, 73, BM_PACKEDMONO, 4, 3, 1, &picData};

  if (!(wserver = w_init())) {
    fprintf(stderr, "error: cpyrgt can't connect to wserver\n");
    return -1;
  }

  if (!(win = w_create(WIDTH, HEIGHT, W_TOP))) {
    fprintf(stderr, "error: cpyrgt can't create window\n");
    return -1;
  }

  tiny = w_loadfont("cour8.wfnt");
  small = w_loadfont("lucidat10.wfnt");
  medium = w_loadfont("lucidat14.wfnt");
  big = w_loadfont("lucidat24.wfnt");

  for (x=0; x<WIDTH; x++)
    w_line(win, x, 0, WIDTH-1-x, HEIGHT-1);
  for (y=0; y<HEIGHT; y++)
    w_line(win, 0, y, WIDTH-1, HEIGHT-1-y);

  w_setmode(win, M_CLEAR);
  w_pbox(win, 20, 20, WIDTH-40, HEIGHT-40);

  w_setmode(win, M_DRAW);
  w_putblock(&grafik, 8, 0, 80, 73, win, 123, 31);

  w_querywinsize(win, 1, &ewidth, &eheight);
  w_open(win, (wserver->width-ewidth)/2, (wserver->height-eheight)/2);

  w_setfont(win, big);
  w_printstring(win,  40, 100, "W 1 Release 3");

  w_setfont(win, medium);
  w_printstring(win, 30, 126, "(C) 02/96 by Torsten Scherer");

  w_setfont(win, tiny);
  w_printstring(win, 45, 140, "itschere@techfak.uni-bielefeld.de");

  w_setfont(win, small);
  w_printstring(win, 132, 20, "welcome to");
  w_printstring(win, 68, 150, "this is experimental software,");
  w_printstring(win, 83, 159, "use it at your own risk!");

  w_setmode(win, M_INVERS);
  for (i=0; i<24; i++) {
    if ((event = w_queryevent(NULL, NULL, NULL, 500))) switch (event->type) {
      case EVENT_GADGET:
        if (event->key == GADGET_EXIT) {
	  return 0;
	}
	break;
    }
    w_pbox(win, 40,150, 235, 20);
  }

  return 0;
}
