/*
 * lib/window.c, part of Wlib, part of W
 * (C) 94-02/96 by Torsten Scherer (TeSche)
 * itschere@techfak.uni-bielefeld.de
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "Wlib.h"
#include "../server/config.h"
#include "../server/pakets.h"
#include "proto.h"


WWIN *w_create(short width, short height, short flags)
{
  WWIN *ptr;
  CREATEP paket;
  ushort ret;

  TRACESTART();

  if (!(ptr = malloc(sizeof(WWIN)))) {
    TRACEPRINT(("w_create(%i,%i,0x%04x) -> NULL\n",\
		width, height, (unsigned int)flags));
    TRACEEND();
    return NULL;
  }

  paket.len = sizeof(CREATEP);
  paket.type = PAK_CREATE;
  paket.width = htons(width);
  paket.height = htons(height);
  paket.flags = htons(flags);
  paket.libPtr = ptr;
  _send_paket((PAKET *)&paket);

  if (!(ret = ntohs(((SRETP *)_wait4paket(PAK_SRET))->ret))) {
    free(ptr);
    TRACEPRINT(("w_create(%i,%i,0x%04x) -> NULL\n",\
		width, height, (unsigned int)flags));
    TRACEEND();

    return NULL;
  }

  ptr->magic = MAGIC_W;
  ptr->handle = ret;
  ptr->width = width;
  ptr->height = height;
  ptr->drawmode = M_INVERS;
  ptr->pattern = GRAY_PATTERN;
  ptr->font = NULL;

  TRACEPRINT(("w_create(%i,%i,0x%04x) -> 0x%08x\n",\
	      width, height, (unsigned int)flags, (unsigned int)ptr));
  TRACEEND();

  return ptr;
}


WWIN *w_createChild(WWIN *parent, short width, short height, short flags)
{
  WWIN *ptr;
  CREATEP paket;
  ushort ret;
  char *cptr;

  TRACESTART();

  if ((cptr = _check_window(parent))) {
    TRACEPRINT(("w_createChild(0x%08x,%i,%i,0x%04x) -> NULL\n",\
		(unsigned int)parent, width, height, (unsigned int)flags));
    TRACEEND();
    return NULL;
  }

  if (!(ptr = malloc(sizeof(WWIN)))) {
    TRACEPRINT(("w_createChild(0x%08x,%i,%i,0x%04x) -> NULL\n",\
		(unsigned int)parent, width, height, (unsigned int)flags));
    TRACEEND();
    return NULL;
  }

  paket.len = sizeof(CREATEP);
  paket.type = PAK_CREATE2;
  paket.width = htons(width);
  paket.height = htons(height);
  paket.flags = htons(flags);
  paket.handle = htons(parent->handle);
  paket.libPtr = ptr;
  _send_paket((PAKET *)&paket);

  if (!(ret = ntohs(((SRETP *)_wait4paket(PAK_SRET))->ret))) {
    free(ptr);
    TRACEPRINT(("w_createChild(0x%08x,%i,%i,0x%04x) -> NULL\n",\
		(unsigned int)parent, width, height, (unsigned int)flags));
    TRACEEND();

    return NULL;
  }

  ptr->magic = MAGIC_W;
  ptr->handle = ret;
  ptr->width = width;
  ptr->height = height;
  ptr->drawmode = M_INVERS;
  ptr->pattern = 0xaaaa;
  ptr->font = NULL;
  ptr->type = WWIN_NORMAL;

  TRACEPRINT(("w_createChild(0x%08x,%i,%i,0x%04x) -> 0x%08x\n",\
	      (unsigned int)parent, width, height, (unsigned int)flags,
	      (unsigned int)ptr));
  TRACEEND();

  return ptr;
}


short w_settitle(WWIN *win, char *s)
{
  char *cptr;
  STITLEP paket;

  TRACESTART();

  if ((cptr = _check_window(win))) {
    TRACEPRINT(("w_settitle(0x%08x,%s) -> %s\n", (unsigned int)win, s, cptr));
    TRACEEND();
    return -1;
  }

  TRACEPRINT(("w_settitle(0x%08x,%s)\n", (unsigned int)win, s));

  paket.len = sizeof(STITLEP);
  paket.type = PAK_STITLE;
  paket.handle = htons(win->handle);
  strncpy(paket.title, s, 63);
  paket.title[63] = 0;
  _send_paket((PAKET *)&paket);

  TRACEEND();

  return 0;
}


short w_open(WWIN *win, short x0, short y0)
{
  char *cptr;
  OPENP paket;
  short ret;

  TRACESTART();

  if ((cptr = _check_window(win))) {
    TRACEPRINT(("w_open(0x%08x,%i,%i) -> %s\n",\
		(unsigned int)win, x0, y0, cptr));
    TRACEEND();
    return -1;
  }

  paket.len = sizeof(OPENP);
  paket.type = PAK_OPEN;
  paket.handle = htons(win->handle);
  paket.x0 = htons(x0);
  paket.y0 = htons(y0);
  _send_paket((PAKET *)&paket);

  ret = ntohs(((SRETP *)_wait4paket(PAK_SRET))->ret);

  TRACEPRINT(("w_open(0x%08x,%i,%i) -> %i\n",\
	      (unsigned int)win, x0, y0, ret));

  TRACEEND();

  return ret;
}


short w_move(WWIN *win, short x0, short y0)
{
  char *cptr;
  MOVEP paket;
  short ret;

  TRACESTART();

  if ((cptr = _check_window(win))) {
    TRACEPRINT(("w_move(0x%08x,%i,%i) -> %s\n",\
		(unsigned int)win, x0, y0, cptr));
    TRACEEND();
    return -1;
  }

  paket.len = sizeof(MOVEP);
  paket.type = PAK_MOVE;
  paket.handle = htons(win->handle);
  paket.x0 = htons(x0);
  paket.y0 = htons(y0);
  _send_paket((PAKET *)&paket);

  ret = ntohs(((SRETP *)_wait4paket(PAK_SRET))->ret);

  TRACEPRINT(("w_move(0x%08x,%i,%i) -> %i\n",\
	      (unsigned int)win, x0, y0, ret));

  TRACEEND();

  return ret;
}


short w_close(WWIN *win)
{
  char *cptr;
  CLOSEP	paket;
  short ret;

  TRACESTART();

  if ((cptr = _check_window(win))) {
    TRACEPRINT(("w_close(0x%08x) -> %s\n",\
		(unsigned int)win, cptr));
    TRACEEND();
    return -1;
  }

  paket.len = sizeof(CLOSEP);
  paket.type = PAK_CLOSE;
  paket.handle = htons(win->handle);
  _send_paket((PAKET *)&paket);

  ret = ntohs(((SRETP *)_wait4paket(PAK_SRET))->ret);

  TRACEPRINT(("w_close(0x%08x) -> %i\n",\
	      (unsigned int)win, ret));

  TRACEEND();

  return ret;
}


short w_delete(WWIN *win)
{
  DELETEP paket;
  short ret;

  TRACESTART();

  paket.len = sizeof(DELETEP);
  paket.type = PAK_DELETE;
  paket.handle = htons(win->handle);
  _send_paket((PAKET *)&paket);

  if (!(ret = ntohs(((SRETP *)_wait4paket(PAK_SRET))->ret))) {

    free(win);
    TRACEPRINT(("w_delete(0x%08x)\n", (unsigned int)win));

    TRACEEND();
    return 0;
  }

  TRACEPRINT(("w_delete(0x%08x) -> %i\n", (unsigned int)win, ret));

  TRACEEND();

  return ret;
}
