/*
 * lib/text.c, part of W
 * (C) 94-02/96 by Torsten Scherer (TeSche)
 * itschere@techfak.uni-bielefeld.de
 *
 * some functions dealing with text
 *
 * - TeSche 23.01.96: w_printstring() can now print strings of any size
 */

#include <stdio.h>
#include <stddef.h>
#include <string.h>
#include "Wlib.h"
#include "../server/config.h"
#include "../server/pakets.h"
#include "proto.h"


short w_printchar(WWIN *win, short x0, short y0, short c)
{
  char *cptr;
  WFONT *font;
  PRINTCP paket;

  c &= 0xff;

  TRACESTART();

  if ((cptr = _check_window(win))) {
    TRACEPRINT(("w_printchar(0x%08x,%i,%i,%i) -> %s\n",\
		(unsigned int)win, x0, y0, c, cptr));
    TRACEEND();
    return -1;
  }

  if (!(font = win->font)) {
    TRACEPRINT(("w_printchar(0x%08x,%i,%i,%i) -> no font\n",\
		(unsigned int)win, x0, y0, c));
    TRACEEND();
    return -1;
  }

  paket.len = sizeof(PRINTCP);
  paket.type = PAK_PRINTC;
  paket.handle = htons(win->handle);
  paket.x0 = htons(x0);
  paket.y0 = htons(y0);
  paket.c = (ushort)htons(c);
  _send_paket((PAKET *)&paket);

  TRACEPRINT(("w_printchar(0x%08x,%i,%i,%i)\n",\
	      (unsigned int)win, x0, y0, c));

  TRACEEND();
  return 0;
}


short w_printstring(WWIN *win, short x0, short y0, char *s)
{
  char *cptr;
  PRINTSP paket;
  WFONT *font;
  int len, todo;

  TRACESTART();

  if ((cptr = _check_window(win))) {
    TRACEPRINT(("w_printstring(0x%08x,%i,%i,\"%s\") -> %s\n",\
		(unsigned int)win, x0, y0, s, cptr));
    TRACEEND();
    return -1;
  }

  if (!(font = win->font)) {
    TRACEPRINT(("w_printstring(0x%08x,%i,%i,\"%s\") -> no font\n",\
		(unsigned int)win, x0, y0, s));
    TRACEEND();
    return -1;
  }

  TRACEPRINT(("w_printstring(0x%08x,%i,%i,\"%s\")...\n",\
	      (unsigned int)win, x0, y0, s));

  len = strlen(s);
  cptr = s;

  while (len > 0) {
    todo = MIN(len + 1, MAXPRINTS);
    strncpy(paket.s, cptr, todo);
    paket.s[todo - 1] = 0;

    paket.len = offsetof(PRINTSP, s) + ((todo + 3) & ~3);
    paket.type = PAK_PRINTS;
    paket.handle = htons(win->handle);
    paket.x0 = htons(x0);
    paket.y0 = htons(y0);
    strncpy(paket.s, s, 63);
    paket.s[63] = 0;
    _send_paket((PAKET *)&paket);

    todo -= 1;
    cptr += todo;
    len -= todo;
    if (len > 0) {
      x0 += w_strlen(font, cptr);
    }
  }

  TRACEPRINT(("w_printstring() -> 0\n"));

  TRACEEND();
  return 0;
}


int w_strlen(WFONT *font, char *s)
{
  int len;
  char *cptr = s;

  TRACESTART();

  if (!font) {
    TRACEPRINT(("w_strlen(0x%08x,\"%s\") -> -1\n", (unsigned int)font, s));
    TRACEEND();
    return -1;
  }

  if (font->magic != MAGIC_F) {
    TRACEPRINT(("w_strlen(0x%08x,\"%s\") -> -1\n", (unsigned int)font, s));
    TRACEEND();
    return -1;
  }

  len = 0;
  while (*cptr) {
    len += font->widths[(int)*cptr++];
  }

  TRACEPRINT(("w_strlen(0x%08x,\"%s\") -> %i\n", (unsigned int)font, s, len));

  TRACEEND();
  return len;
}
