/*
 * lib/settings.c, part of Wlib, part of W
 * (C) 94-02/96 by Torsten Scherer (TeSche)
 * itschere@techfak.uni-bielefeld.de
 */

#include <stdio.h>
#include "Wlib.h"
#include "../server/config.h"
#include "../server/pakets.h"
#include "proto.h"


short w_settextstyle(WWIN *win, short flags)
{
  char *cptr;
  STEXTSTYLEP paket;
  short old;

  TRACESTART();

  if ((cptr = _check_window(win))) {
    TRACEPRINT(("w_settextstyle(0x%08x,%i) -> %s\n",\
		(unsigned int)win, flags, cptr));
    TRACEEND();
    return -1;
  }

  paket.len = sizeof(STEXTSTYLEP);
  paket.type = PAK_STEXTSTYLE;
  paket.handle = htons(win->handle);
  old = win->textstyle;
  paket.flags = htons(win->textstyle = flags & F_STYLEMASK);
  _send_paket((PAKET *)&paket);

  TRACEPRINT(("w_settextstyle(0x%08x,%i)\n", (unsigned int)win, flags));

  TRACEEND();
  return old;
}


short w_setsaver(short seconds)
{
  SSAVERP paket;
  short ret;

  TRACESTART();

  paket.len = sizeof(SSAVERP);
  paket.type = PAK_SSAVER;
  paket.seconds = htonl(seconds);
  _send_paket((PAKET *)&paket);

  ret =  ntohs(((SRETP *)_wait4paket(PAK_SRET))->ret);

  TRACEPRINT(("w_setsaver(%i) -> %i\n", seconds, ret));

  TRACEEND();
  return ret;
}


ushort w_setpattern(WWIN *win, ushort pattern)
{
  char *cptr;
  SPATTERNP paket;
  ushort old;

  TRACESTART();

  if ((cptr = _check_window(win))) {
    TRACEPRINT(("w_(0x%08x,0x%04x) -> %s\n",
		(unsigned int)win, (unsigned int)pattern, cptr));
    TRACEEND();
    return 0;
  }

  paket.len = sizeof(SPATTERNP);
  paket.type = PAK_SPATTERN;
  paket.handle = htons(win->handle);
  old = win->pattern;
  paket.pattern = htons(win->pattern = pattern);     /* signed vs. unsigned? */
  _send_paket((PAKET *)&paket);

  TRACEPRINT(("w_(0x%08x,0x%04x) -> 0x%04x\n",
	      (unsigned int)win, (unsigned int)pattern, old));

  TRACEEND();
  return old;
}


short w_setmode(WWIN *win, short mode)
{
  char *cptr;
  SMODEP paket;
  short old;

  TRACESTART();

  if ((cptr = _check_window(win))) {
    TRACEPRINT(("w_setmode(0x%08x,%i) -> %s\n", (unsigned int)win, mode, cptr));
    TRACEEND();
    return -1;
  }

  paket.len = sizeof(SMODEP);
  paket.type = PAK_SMODE;
  paket.handle = htons(win->handle);
  old = win->drawmode;
  paket.mode = htons(win->drawmode = mode);
  _send_paket((PAKET *)&paket);

  TRACEPRINT(("w_setmode(0x%08x,%i) -> %i\n",\
	      (unsigned int)win, mode, old));

  TRACEEND();
  return old;
}
