/*
 * lib/queries.c, part of W
 * (C) 94-02/96 by Torsten Scherer (TeSche)
 * itschere@techfak.uni-bielefeld.de
 */

#include <stdio.h>
#include "Wlib.h"
#include "../server/config.h"
#include "../server/pakets.h"
#include "proto.h"


short w_querywinsize(WWIN *win, short effective, short *width, short *height)
{
  char *cptr;
  QWINSZP paket;
  S3RETP *rpaket;

  TRACESTART();

  if ((cptr = _check_window(win))) {
    TRACEPRINT(("w_querywinsize(0x%08x,%i,0x%08x,0x%08x) -> %s\n",\
		(unsigned int)win, effective, (unsigned int)width,\
		(unsigned int)height, cptr));
    TRACEEND();
    return -1;
  }

  paket.len = sizeof(QWINSZP);
  paket.type = PAK_QWINSZ;
  paket.handle = htons(win->handle);
  paket.effective = htons(effective);
  _send_paket((PAKET *)&paket);

  rpaket = (S3RETP *)_wait4paket(PAK_S3RET);
  if (width) *width = ntohs(rpaket->ret[0]);
  if (height) *height = ntohs(rpaket->ret[1]);

  TRACEPRINT(("w_querywinsize(0x%08x,%i,0x%08x,0x%08x) -> %i,%i\n",\
	      (unsigned int)win, effective,\
	      (unsigned int)width, (unsigned int)height,\
	      ntohs(rpaket->ret[0]), ntohs(rpaket->ret[1])));

  TRACEEND();
  return ntohs(rpaket->ret[2]);
}


short w_querywindowpos(WWIN *win, short effective, short *x0, short *y0)
{
  char *cptr;
  QWPOSP paket;
  S3RETP *rpaket;
  short ret;

  TRACESTART();

  if ((cptr = _check_window(win))) {
    TRACEPRINT(("w_querywindowpos(0x%08x,%i,0x%08x,0x%08x) -> %s\n",\
		(unsigned int)win, effective, (unsigned int)x0,\
		(unsigned int)y0, cptr));
    TRACEEND();
    return -1;
  }

  paket.len = sizeof(QWPOSP);
  paket.type = PAK_QWPOS;
  paket.handle = htons(win->handle);
  paket.effective = htons(effective);
  _send_paket((PAKET *)&paket);

  rpaket = (S3RETP *)_wait4paket(PAK_S3RET);
  if (x0)
    *x0 = ntohs(rpaket->ret[0]);
  if (y0)
    *y0 = ntohs(rpaket->ret[1]);
  ret = ntohs(rpaket->ret[2]);

  TRACEPRINT(("w_querywindowpos(0x%08x,%i,0x%08x,0x%08x) -> %i,%i\n",\
	      (unsigned int)win, effective, (unsigned int)x0,\
	      (unsigned int)y0, ntohs(rpaket->ret[0]), ntohs(rpaket->ret[1])));

  TRACEEND();
  return ret;
}


short w_querystatus(STATUS *st, short index)
{
  QSTATUSP paket;
  RSTATUSP *rpaket;
  short ret;

  TRACESTART();

  paket.len = sizeof(QSTATUSP);
  paket.type = PAK_QSTATUS;
  paket.index = htons(index);
  _send_paket((PAKET *)&paket);

  rpaket = (RSTATUSP *)_wait4paket(PAK_RSTATUS);
  if (st) {
    st->ip_addr = ntohl(rpaket->status.ip_addr);
    st->pakets = ntohl(rpaket->status.pakets);
    st->bytes = ntohl(rpaket->status.bytes);
    st->totalWin = ntohs(rpaket->status.totalWin);
    st->openWin = ntohs(rpaket->status.openWin);
  }

  ret = ntohs(rpaket->ret);

  TRACEPRINT(("w_querystatus(0x%08x,%i) -> %i\n",\
	      (unsigned int)st, index, ntohs(rpaket->ret)));

  TRACEEND();
  return ret;
}


short w_querymousepos(WWIN *win, short *x0, short *y0)
{
  QMPOSP paket;
  S3RETP *rpaket;
  short ret;

  TRACESTART();

  paket.len = sizeof(QMPOSP);
  paket.type = PAK_QMPOS;
  if (win) {
    paket.handle = htons(win->handle);
  } else {
    paket.handle = htons(0);
  }
  _send_paket((PAKET *)&paket);

  rpaket = (S3RETP *)_wait4paket(PAK_S3RET);
  if (x0)
    *x0 = ntohs(rpaket->ret[0]);
  if (y0)
    *y0 = ntohs(rpaket->ret[1]);

  ret = ntohs(rpaket->ret[2]);

  TRACEPRINT(("w_querymousepos(0x%08x,0x%08x,0x%08x) -> %i,%i\n",\
	      (unsigned int)win, (unsigned int)x0, (unsigned int)y0,\
	      ntohs(rpaket->ret[0]), ntohs(rpaket->ret[1])));

  TRACEEND();
  return ret;
}
