/*
 * lib/poly.c, part of W
 * (C) 94-02/96 by Torsten Scherer (TeSche)
 * itschere@techfak.uni-bielefeld.de
 */

#include <stdio.h>
#include <stddef.h>
#include "Wlib.h"
#include "../server/config.h"
#include "../server/pakets.h"
#include "proto.h"


static short poly(WWIN *win, short numpoints, short *points, short type, char *fname)
{
  char *cptr;
  POLYP paket;
  long i;

  TRACESTART();

  if ((cptr = _check_window(win))) {
    TRACEPRINT(("%s(0x%08x,%i,0x%08x) -> %s\n",\
		fname, (unsigned int)win, numpoints, (unsigned int)points, cptr));
    TRACEEND();
    return -1;
  }

  if (numpoints > MAXPOLYPOINTS) {
    TRACEPRINT(("%s(0x%08x,%i,0x%08x) -> too many points\n",\
		fname, (unsigned int)win, numpoints, (unsigned int)points));
    TRACEEND();
    return -1;
  }

  if (numpoints < 3) {
    TRACEPRINT(("%s(0x%08x,%i,0x%08x) -> too few points\n",\
		fname, (unsigned int)win, numpoints, (unsigned int)points));
    TRACEEND();
    return -1;
  }

  paket.numpoints = htons(numpoints);
  numpoints <<= 1;
  for (i=0; i<numpoints; i++) {
    paket.points[i] = htons(*points);
    ++points;
  }
  paket.len = offsetof(POLYP, points) + (numpoints << 1);
  paket.type = type;
  paket.handle = htons(win->handle);
  _send_paket((PAKET *)&paket);

  TRACEPRINT(("%s(0x%08x,%i,0x%08x)\n",\
	      fname, (unsigned int)win, numpoints, (unsigned int)points));

  TRACEEND();
  return 0;
}


short w_poly(WWIN *win, short numpoints, short *points)
{
  return poly(win, numpoints, points, PAK_POLY, "w_poly");
}


short w_ppoly(WWIN *win, short numpoints, short *points)
{
  return poly(win, numpoints, points, PAK_PPOLY, "w_ppoly");
}


short w_dpoly(WWIN *win, short numpoints, short *points)
{
  return poly(win, numpoints, points, PAK_DPOLY, "w_dpoly");
}


short w_dppoly(WWIN *win, short numpoints, short *points)
{
  return poly(win, numpoints, points, PAK_DPPOLY, "w_dppoly");
}
