/*
 * lib/init.c, part of Wlib, part of W
 * (C) 94-02/96 by Torsten Scherer (TeSche)
 * itschere@techfak.uni-bielefeld.de
 */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include "Wlib.h"
#include "../server/config.h"
#include "../server/pakets.h"
#include "proto.h"


WSERVER *w_init(void)
{
  INITP paket;
  INITRETP *irpaket;
  static WSERVER wserver;
  static WWIN wroot = {MAGIC_W, 0, -1, -1, M_DRAW, 0xAAAA, F_NORMAL, NULL};

  TRACESTART();

  if (_initialize() < 0) {
    TRACEPRINT(("w_init() -> NULL\n"));
    TRACEEND();
    return NULL;
  }

  paket.len = sizeof(INITP);
  paket.type = PAK_INIT;
  paket.uid = htons(getuid());
  _send_paket((PAKET *)&paket);

  irpaket = (INITRETP *)_wait4paket(PAK_INITRET);

  wserver.vmaj = htons(irpaket->vmaj);
  wserver.vmin = htons(irpaket->vmin);
  wserver.width = htons(irpaket->width);
  wserver.height = htons(irpaket->height);
  wserver.colors = htons(irpaket->colors);

  if ((wserver.vmaj != _WMAJ) || (wserver.vmin != _WMIN)) {
    fprintf(stderr, "Wlib: this binary was compiled for W%iR%i, but\n",
	    _WMAJ, _WMIN);
    fprintf(stderr, "      the server claims to be W%iR%i, update your binary!\n",
	    wserver.vmaj, wserver.vmin);
    exit(-99);
  }

  TRACEPRINT(("w_init() -> 0x%08x\n", (unsigned int)irpaket));

  wroot.width = wserver.width;
  wroot.height = wserver.height;
  wroot.font = NULL;
  WROOT = &wroot;

  TRACEEND();
  return &wserver;
}


void w_exit(void)
{
  EXITP	expaket;

  TRACESTART();
  TRACEPRINT(("w_exit()\n"));

  expaket.len = sizeof(EXITP);
  expaket.type = PAK_EXIT;
  _send_paket((PAKET *)&expaket);

  TRACEEND();
}


short w_null(void)
{
  INITP paket;

  TRACESTART();
  TRACEPRINT(("w_null()\n"));

  paket.len = 4;
  paket.type = PAK_NULL;
  _send_paket((PAKET *)&paket);

  TRACEEND();

  return 0;
}


short w_beep(void)
{
  short paket[2];

  TRACESTART();
  TRACEPRINT(("w_beep()\n"));

  paket[0] = 4;
  paket[1] = PAK_BEEP;
  _send_paket((PAKET *)paket);

  TRACEEND();

  return 0;
}


void w_trace(short flag)
{
#ifdef TRACE
  _trace = !!flag;

  TRACESTART();
  TRACEPRINT(("w_trace(%i)\n", flag));
  TRACEEND();
#else
  fprintf(stderr, "w_trace: tracing not implemented\n");
#endif
}
