/*
 * lib/geometry.c, part of Wlib, part of W
 * (C) 94-02/96 by Torsten Scherer (TeSche)
 * itschere@techfak.uni-bielefeld.de
 *
 * how to scan a geometry argument?
 */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "Wlib.h"
#include "../server/config.h"
#include "../server/pakets.h"
#include "proto.h"


void scan_geometry(char *geometry, short *col, short *lin,
		   short *xp, short *yp)
{
  TRACESTART();

  TRACEPRINT(("scan_geometry(%s,0x%08x,0x%08x,0x%08x,0x%08x)\n",\
	      geometry, (unsigned int)col, (unsigned int)lin,\
	      (unsigned int)xp, (unsigned int)yp));

  if (col)
    *col = UNDEF;
  if (lin)
    *lin = UNDEF;
  if (xp)
    *xp = UNDEF;
  if (yp)
    *yp = UNDEF;

  if (!geometry) {
    TRACEEND();
    return;
  }

  if (col)
    *col = atoi(geometry);

  if (!(geometry = strchr(geometry, ','))) {
    TRACEEND();
    return;
  }

  if (lin)
    *lin = atoi(++geometry);
  else
    geometry++;

  if (!(geometry = strchr(geometry, ','))) {
    TRACEEND();
    return;
  }

  if (xp) {
    *xp = atoi(++geometry);
    if (*geometry == '-') {
      *xp -= 1;
    }
  }
  else
    geometry++;

  if (!(geometry = strchr(geometry, ','))) {
    TRACEEND();
    return;
  }

  if (yp) {
    *yp = atoi(++geometry);
    if (*geometry == '-') {
      *yp -= 1;
    }
  }

  TRACEEND();
}
