/*
 * lib/font.c, part of Wlib, part of W
 * (C) 94-02/96 by Torsten Scherer (TeSche)
 * itschere@techfak.uni-bielefeld.de
 */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "Wlib.h"
#include "../server/config.h"
#include "../server/pakets.h"
#include "proto.h"


WFONT *w_loadfont(char *fontname)
{
  WFONT *fptr;
  LOADFONTP paket;
  LFONTRETP *lfontretp;

  TRACESTART();

  if (!(fptr = malloc(sizeof(WFONT)))) {
    TRACEPRINT(("w_loadfont(%s) -> NULL (out of memory)\n",\
		fontname));
    TRACEEND();
    return NULL;
  }

  paket.len = sizeof(LOADFONTP);
  paket.type = PAK_LOADFONT;
  strncpy(paket.fontname, fontname, 63);
  paket.fontname[63] = 0;
  _send_paket((PAKET *)&paket);

  lfontretp = (LFONTRETP *)_wait4paket(PAK_LFONTRET);

  if ((fptr->handle = ntohs(lfontretp->handle)) < 0) {
    TRACEPRINT(("w_loadfont(%s) -> NULL\n",\
		fontname));
    TRACEEND();
    free(fptr);
    return NULL;
  }

  fptr->magic = MAGIC_F;
  fptr->flags = ntohs(lfontretp->flags);
  fptr->height = ntohs(lfontretp->height);
  memcpy(fptr->widths, lfontretp->widths, 256);

  TRACEPRINT(("w_loadfont(%s) -> 0x%08x\n",\
	      fontname, (unsigned int)fptr));
  TRACEEND();

  return fptr;
}


short w_unloadfont(WFONT *font)
{
  UNLOADFONTP paket;
  short ret;

  TRACESTART();

  if (!font) {
    TRACEPRINT(("w_unloadfont(0x%08x) -> -1\n",\
		(unsigned int)font));
    TRACEEND();
    return -1;
  }

  if (font->magic != MAGIC_F) {
    TRACEPRINT(("w_unloadfont(0x%08x) -> -1\n",\
		(unsigned int)font));
    TRACEEND();
    return -1;
  }

  paket.len = sizeof(UNLOADFONTP);
  paket.type = PAK_UNLOADFONT;
  paket.fonthandle = htons(font->handle);
  _send_paket((PAKET *)&paket);

  if (!(ret = ntohs(((SRETP *)_wait4paket(PAK_SRET))->ret))) {
    free(font);
  }

  TRACEPRINT(("w_unloadfont(0x%08x) -> %i\n",
	      (unsigned int)font, ret));
  TRACEEND();

  return ret;
}


WFONT *w_setfont(WWIN *win, WFONT *font)
{
  char *cptr;
  SFONTP paket;
  WFONT *oldfont;

  TRACESTART();

  if ((cptr = _check_window(win))) {
    TRACEPRINT(("w_setfont(0x%08x,0x%08x) -> %s\n",\
		(unsigned int)win, (unsigned int)font, cptr));
    TRACEEND();
    return NULL;
  }

  if (font && (font->magic != MAGIC_F)) {
    TRACEPRINT(("w_setfont(0x%08x,0x%08x) -> font error\n",\
		(unsigned int)win, (unsigned int)font));
    TRACEEND();
    return NULL;
  }

  paket.len = sizeof(SFONTP);
  paket.type = PAK_SFONT;
  oldfont = win->font;
  paket.handle = htons(win->handle);
  if (font) {
    paket.fonthandle = htons((win->font = font) -> handle);
  } else {
    paket.fonthandle = htons(-1);
  }
  _send_paket((PAKET *)&paket);
  TRACEPRINT(("w_setfont(0x%08x,0x%08x) -> 0x%08x\n",\
	      (unsigned int)win, (unsigned int)font, (unsigned int)oldfont));

  TRACEEND();
  return oldfont;
}
