/*
 * lib/event.c, part of Wlib, part of W
 * (C) 94-02/96 by Torsten Scherer (TeSche)
 * itschere@techfak.uni-bielefeld.de
 *
 * the main event function
 */

#include <stdio.h>
#include <string.h>
#include "Wlib.h"
#include "../server/config.h"
#include "../server/pakets.h"
#include "proto.h"


WEVENT *w_queryevent(fd_set *rfd, fd_set *wfd, fd_set *xfd, long timeout)
{
  WEVENT *tmp;
  short numready, oldmode;
  static WWIN *selected = NULL;
  fd_set mrfd, mwfd, mxfd;
  int forceRepeat;

  TRACESTART();
  TRACEPRINT(("w_queryevent(0x%08x,0x%08x,0x%08x,%li) -> ?\n",\
	      (unsigned int)rfd, (unsigned int)wfd, (unsigned int)xfd,\
	      timeout));

  do {
    if (rfd) {
      mrfd = *rfd;
    } else {
      FD_ZERO(&mrfd);
    }
    if (wfd) {
      mwfd = *wfd;
    } else {
      FD_ZERO(&mwfd);
    }
    if (xfd) {
      mxfd = *xfd;
    } else {
      FD_ZERO(&mxfd);
    }

    /* normally we run through this loop only once, except when we caught a
     * button event: in this case we do it again. this may involve selecting
     * other sockets twice - quite an overhead - but seems better to me than
     * forcing a WWIN_BUTTON press and release to be served with two
     * seperate calls - the client might not like that.
     */

    forceRepeat = 0;

    if ((tmp = _wait4event(&mrfd, &mwfd, &mxfd, timeout, &numready))) {

      if ((tmp->type == EVENT_MPRESS) || (tmp->type == EVENT_MRELEASE))
	switch (tmp->win->type) {

        case WWIN_NORMAL:
	  break;

        case WWIN_BUTTON:
	  if ((tmp->type == EVENT_MPRESS) && (tmp->key == BUTTON_LEFT)) {

	    /* graphically `select' button */
	    oldmode = w_setmode(tmp->win, M_INVERS);
	    w_pbox(tmp->win, 0, 0, tmp->win->width, tmp->win->height);
	    w_setmode(tmp->win, oldmode);

	    selected = tmp->win;

	    /* try to get the corresponding release event ASAP */
	    forceRepeat = 1;

	  } else if ((tmp->type == EVENT_MRELEASE) && (tmp->key == BUTTON_LEFT)) {

	    /* graphically `unselect' button, if it doesn't exist anymore,
	     * nothing will happen
	     */
	    oldmode = w_setmode(tmp->win, M_INVERS);
	    w_pbox(tmp->win, 0, 0, tmp->win->width, tmp->win->height);
	    w_setmode(tmp->win, oldmode);

	    if ((tmp->win == selected) && (tmp->x >= 0) && (tmp->y >= 0)) {
	      tmp->type = EVENT_BUTTON;
	    } else {
	      tmp = NULL;
	      /* sleep on */
	      forceRepeat = 1;
	    }
	    selected = NULL;
	  }
	  break;
      }
    }
  } while (forceRepeat);

  if (rfd) {
    *rfd = mrfd;
  }
  if (wfd) {
    *wfd = mwfd;
  }
  if (xfd) {
    *xfd = mxfd;
  }

  TRACEPRINT(("w_queryevent() -> 0x%08x\n", (unsigned int)tmp));
  TRACEEND();

  return tmp;
}

