/*
 * lib/button.c, part of Wlib, part of W
 * (C) 94-02/96 by Torsten Scherer (TeSche)
 * itschere@techfak.uni-bielefeld.de
 */

#include <stdio.h>
#include <stdlib.h>
#include "Wlib.h"
#include "../server/config.h"
#include "../server/pakets.h"
#include "proto.h"


/*
 * some functions dealing with `buttons'
 */

WWIN *w_createButton(WWIN *parent, short x0, short y0, short width, short height)
{
  char *cptr;
  WWIN *ret;

  TRACESTART();

  if ((cptr = _check_window(parent))) {
    TRACEPRINT(("w_createChild(0x%08x,%i,%i) -> NULL\n",\
		(unsigned int)parent, width, height));
    TRACEEND();
    return NULL;
  }

  if (!(ret = w_createChild(parent, width, height, EV_MOUSE))) {
    TRACEPRINT(("w_createChild(0x%08x,%i,%i) -> NULL\n",\
		(unsigned int)parent, width, height));
    TRACEEND();
    return NULL;
  }

  ret->type = WWIN_BUTTON;
  ret->x0 = x0;
  ret->y0 = y0;

  TRACEPRINT(("w_createChild(0x%08x,%i,%i) -> 0x%08x\n",\
	      (unsigned int)parent, width, height,
	      (unsigned int)ret));
  TRACEEND();

  return ret;
}


short w_centerPrints(WWIN *win, WFONT *font, char *s)
{
  char *cptr;
  int len;
  WFONT *oldFont;

  TRACESTART();

  if ((cptr = _check_window(win))) {
    TRACEPRINT(("w_centerPrints(0x%08x,0x%08x,0x%08x) -> -1\n",\
		(unsigned int)win, (unsigned int)font, (unsigned int)s));
    TRACEEND();
    return -1;
  }

  TRACEPRINT(("w_centerPrints(0x%08x,0x%08x,0x%08x)...\n",\
	      (unsigned int)win, (unsigned int)font, (unsigned int)s));

  len = w_strlen(font, s);

  oldFont = w_setfont(win, font);
  w_printstring(win, (win->width >> 1) - (len >> 1),
		(win->height >> 1) - (font->height >> 1), s);

  w_setfont(win, oldFont);

  TRACEPRINT(("w_centerPrints() -> 0\n"));
  TRACEEND();

  return 0;
}


short w_showButton(WWIN *button)
{
  char *cptr;
  short ret;

  TRACESTART();

  if ((cptr = _check_window(button))) {
    TRACEPRINT(("w_showButton(0x%08x) -> %s\n",\
		(unsigned int)button, cptr));
    TRACEEND();
    return -1;
  }

  if (button->type != WWIN_BUTTON) {
    TRACEPRINT(("w_showButton(0x%08x) -> not a button\n",\
		(unsigned int)button));
    TRACEEND();
    return -1;
  }

  TRACEPRINT(("w_showButton()...\n"));

  ret = w_open(button, button->x0, button->y0);

  TRACEPRINT(("w_showButton() -> %i\n", ret));
  TRACEEND();

  return ret;
}


short w_hideButton(WWIN *button)
{
  char *cptr;
  short ret;

  TRACESTART();

  if ((cptr = _check_window(button))) {
    TRACEPRINT(("w_hideButton(0x%08x) -> %s\n",\
		(unsigned int)button, cptr));
    TRACEEND();
    return -1;
  }

  if (button->type != WWIN_BUTTON) {
    TRACEPRINT(("w_hideButton(0x%08x) -> not a button\n",\
		(unsigned int)button));
    TRACEEND();
    return -1;
  }

  TRACEPRINT(("w_hideButton()...\n"));

  ret = w_close(button);

  TRACEPRINT(("w_hideButton() -> %i\n", ret));
  TRACEEND();

  return ret;
}
