/*
 * lib/block.c, part of Wlib, part of W
 * (C) 94-02/96 by Torsten Scherer (TeSche)
 * itschere@techfak.uni-bielefeld.de
 */

#include <stdio.h>
#include <stdlib.h>
#include "Wlib.h"
#include "../server/config.h"
#include "../server/pakets.h"
#include "proto.h"


BITMAP *w_getblock(WWIN *win, short x0, short y0, short width, short height)
{
  char *cptr;
  long size, size2, offset;
  BITMAP *ret;
  GETBLKREQP paket;
  GETBLKDATAP paket2;
  PAKET *rawdata;

  TRACESTART();

  if ((width < 0) || (height < 0)) {
    TRACEPRINT(("w_getblock(0x%08x,%i,%i,%i,%i) -> illegal size\n",\
		(unsigned int)win, x0, y0, width, height));
    TRACEEND();
  }

  if ((cptr = _check_window(win))) {
    TRACEPRINT(("w_getblock(0x%08x,%i,%i,%i,%i) -> %s\n",\
		(unsigned int)win, x0, y0, width, height, cptr));
    TRACEEND();
    return NULL;
  }

  width = (width + 31) & ~31;
  size = (width >> 3) * height;
  if (!(ret = (BITMAP *)malloc(size + sizeof(BITMAP)))) {
    TRACEPRINT(("w_getblock(0x%08x,%i,%i,%i,%i) -> NULL\n",\
		(unsigned int)win, x0, y0, width, height));
    TRACEEND();
    return NULL;
  }
  ret->width = width;
  ret->height = height;
  ret->type = BM_PACKEDMONO;
  ret->unitsize = 4;
  ret->upl = width >> 5;
  ret->planes = 1;
  ret->data = ((void *)ret) + sizeof(BITMAP);

  paket.len = sizeof(GETBLKREQP);
  paket.type = PAK_GETBLKREQ;
  paket.handle = htons(win->handle);
  paket.x0 = htons(x0);
  paket.y0 = htons(y0);
  paket.width = htons(width);
  paket.height = htons(height);
  _send_paket((PAKET *)&paket);

  size2 = ntohl(((LRETP *)_wait4paket(PAK_LRET))->ret);

  offset = 0;
  while (offset < size2) {
    paket2.len = sizeof(GETBLKDATAP);
    paket2.type = PAK_GETBLKDATA;
    _send_paket((PAKET *)&paket2);

    rawdata = _wait4paket(PAK_RAWDATA);
    if (size == size2) {
      memcpy((char *)ret->data + offset, rawdata->data, rawdata->len - 4);
    }
    offset += rawdata->len - 4;
  }

  if (size != size2) {
    free(ret);
    TRACEPRINT(("w_getblock(0x%08x,%i,%i,%i,%i) -> NULL\n",\
		(unsigned int)win, x0, y0, width, height));
    TRACEEND();
    return NULL;
  }

  TRACEPRINT(("w_getblock(0x%08x,%i,%i,%i,%i) -> 0x%08x\n",\
	      (unsigned int)win, x0, y0, width, height, (unsigned int)ret));

  TRACEEND();
  return ret;
}


short w_putblock(BITMAP *bm, short x0, short y0, short width, short height,
		 WWIN *win, short x1, short y1)
{
  char *cptr;
  PUTBLKREQP paket;
  long size, offset, todo;
  PAKET dpaket;

  TRACESTART();

  if ((bm->unitsize != 4) || (bm->width & 31) || (bm->planes != 1)) {
    TRACEPRINT(("w_putblock(0x%08x,%i,%i,%i,%i,0x%08x,%i,%i) -> illegal bitmap parameters\n",\
		(unsigned int)bm, x0, y0, width, height,\
		(unsigned int)win, x1, y1));
    TRACEEND();
    return -1;
  }

  if ((cptr = _check_window(win))) {
    TRACEPRINT(("w_putblock(0x%08x,%i,%i,%i,%i,0x%08x,%i,%i) -> %s\n",\
		(unsigned int)bm, x0, y0, width, height,\
		(unsigned int)win, x1, y1, cptr));
    TRACEEND();
    return -1;
  }

  paket.len = sizeof(PUTBLKREQP);
  paket.type = PAK_PUTBLKREQ;
  paket.rwidth = htons(bm->width);
  paket.rheight = htons(bm->height);
  paket.x0 = htons(x0);
  paket.y0 = htons(y0);
  paket.width = htons(width);
  paket.height = htons(height);
  paket.handle = htons(win->handle);
  paket.x1 = htons(x1);
  paket.y1 = htons(y1);
  _send_paket((PAKET *)&paket);

#ifdef __MINT__
  if (ntohs(((SRETP *)_wait4paket(PAK_SRET))->ret) < 0) {
#else
  /* under Linux htons() is explicitly unsigned :( */
  if (ntohs(((SRETP *)_wait4paket(PAK_SRET))->ret) & 0x8000) {
#endif
    TRACEPRINT(("w_putblock(0x%08x,%i,%i,%i,%i,0x%08x,%i,%i) -> -1\n",\
		(unsigned int)bm, x0, y0, width, height,\
		(unsigned int)win, x1, y1));
    TRACEEND();
    return -1;
  }

  dpaket.type = PAK_RAWDATA;
  offset = 0;
  size = bm->unitsize * bm->upl * bm->height;
  while (offset < size) {
    if ((todo = size - offset) > 252) {
      todo = 252;
    }
    memcpy(dpaket.data, bm->data + offset, todo);
    dpaket.len = todo + 4;
    _send_paket((PAKET *)&dpaket);
    offset += todo;
  }

  TRACEPRINT(("w_putblock(0x%08x,%i,%i,%i,%i,0x%08x,%i,%i) -> 0\n",\
	      (unsigned int)bm, x0, y0, width, height,\
	      (unsigned int)win, x1, y1));

  TRACEEND();
  return 0;
}
