/*
 * Wlib.h - part of W
 * (C) 94-02/96 by Torsten Scherer (TeSche)
 * itschere@techfak.uni-bielefeld.de
 */

#include <sys/types.h>

#define _WMAJ 1
#define _WMIN 2

#ifndef uchar
#define	uchar unsigned char
#endif
#ifndef ushort
#define	ushort unsigned short
#endif
#ifndef ulong
#define	ulong unsigned long
#endif

/* maaan, am I sick & tired to always have to define these... :( */
#undef ABS
#define	ABS(x) (((x)<0)?(-x):(x))
#undef MAX
#define MAX(a,b) ((a)>(b)?(a):(b))
#undef MIN
#define MIN(a,b) ((a)<(b)?(a):(b))

typedef struct {
  short vmaj, vmin;
  short width, height;
  long colors;
} WSERVER;


/*
 * some bitmap types (used inside the server)
 */

#define BM_PACKEDCOLOR 0
#define BM_PACKEDMONO 1
#define BM_DIRECT8 2


/*
 * the definition of all bitmaps. the fields are as following:
 *
 * 'width', 'height' - guess what
 * 'type' - type of bitmap (BM_PACKEDCOLOR, BM_PACKEDMONO or BM_DIRECT8)
 * 'unitsize' - the number of bytes which form an access unit, only interesting
 *              for the 'packed pixel' graphic
 * 'upl' - how many of the above mentioned units make up one line
 * 'planes' - the number of planes for `packed pixel' mode
 * 'data' - gain: guess what
 *
 * a normal ST/TT monochrome screen would have unitsize=4 (because 32 pixels
 * can be accessed at most) and planes=1, whereas a normal ST/TT color screen
 * would have unisize=2 (because planes are 16 pixels wide) and planes>1. the
 * direct8 driver will use unitsize=1 and planes=1 because it doesn't really
 * care about all this fancy adressing.
 *
 * NOTE: ALL BITMAPS YOU USE FOR GET/PUTBLOCK MUST BE BM_PACKEDMONO ONES, I.E.
 * MUST BE LONG-ALIGNED - OTHERWISE THE LIBCALLS WILL BARF AT YOU!
 */

typedef struct {
  short width;
  short height;
  short type;
  short unitsize;
  short upl;
  short planes;
  void *data;
} BITMAP;

typedef struct {
  ulong ip_addr;
  long pakets, bytes;
  short totalWin, openWin;
} STATUS;

typedef struct {
  long magic;   /* MAGIC_F */
  short handle;
  ushort flags;   /* F_BOLD, F_ITALIC, F_PROP... */
  short height, reserved;
  char widths[256];
} WFONT;

typedef struct {
  long magic;   /* MAGIC_W */
  ushort handle;
  short width, height;
  short drawmode;
  ushort pattern;
  short textstyle;
  WFONT *font;

  /* some additional internal information */
  short type, x0, y0, reserved;

  /*
   * a place where the user can store something (eg. a pointer
   * to an additional structure associated with that window).
   */
  long user_val;
} WWIN;

typedef struct {
  WWIN *win;
  short type, reserved[3];
  short x, y;
  long key;
} WEVENT;


/*
 *  various flags
 */

/* drawing modes */
#define	M_CLEAR		0
#define	M_DRAW		1
#define	M_INVERS	2		/* default */

/* drawing styles for filled objects (not yet implemented) */
#define M_EMPTY		16
#define M_SOLID		32		/* default */
#define M_PATTERN	64
#define M_BORDERED	128

/* grayscale patterns (0-MAX_GRAYSCALES) */
#define MAX_GRAYSCALES	64

/* arbitrary patterns */
#define TILE_PATTERN	0xfc
#define W_PATTERN	0xfd
#define GRAY_PATTERN	0xfe		/* default */

/* dline style patterns (0x00ff - 0xffff) */
#define LINE_DASH	0x00ff
#define LINE_DOT	0x5555
#define LINE_DASH_DOT	0xfff3

/* font styles */
#define	F_NORMAL	0x0000
#define	F_INVERS	0x0001
#define	F_UNDERLINE	0x0002

/* something to mask legal styles */
#define	F_STYLEMASK	0x0003

/* special values not used for w_settextstyle(), 0x8000 is negative! */
#define	F_BOLD		0x2000
#define	F_ITALIC	0x4000

#define	W_MOVE		0x0001
#define	W_TOP		0x0002
#define	W_TITLE		0x0004
#define	EV_KEYS		0x0008
#define	EV_MOUSE	0x0010
#define	W_NOBORDER	0x0020
#define	W_NOMOUSE	0x0040
#define EV_ACTIVE	0x0080
#define W_CLOSE		0x0100
#define W_ICON		0x0200
#define	W_CONTAINER	0x0400
#define W_SIZE		0x0800
#define	W_FLAGMASK	0x0fff

#define	BUTTON_LEFT	4
#define	BUTTON_MID	2
#define	BUTTON_RIGHT	1

#define	EVENT_KEY	0x0001
#define	EVENT_MMOVE	0x0002
#define	EVENT_MPRESS	0x0003
#define	EVENT_MRELEASE	0x0004
#define	EVENT_BUTTON	0x0005
#define	EVENT_GADGET	0x0006
#define	EVENT_SAVEON	0x0007
#define	EVENT_SAVEOFF	0x0008
#define EVENT_ACTIVE	0x0009
#define EVENT_INACTIVE	0x000a

#define	GADGET_EXIT	0x0001
#define	GADGET_CLOSE	0x0002
#define GADGET_ICON	0x0003
#define GADGET_SIZE	0x0004

#define	MAGIC_W	0x15263748
#define	MAGIC_F	0x15263749

/* special flag for w_open() */
#define UNDEF -32768


/*
 *
 */

extern WWIN *WROOT;
extern WWIN *WSCREEN;   /* not yet implemented */


/*
 * some functions
 */

extern WSERVER	*w_init(void);
extern void	w_exit(void);
extern WWIN	*w_create(short width, short height, short flags);
extern WWIN	*w_createChild(WWIN *parent, short width, short height, short flags);
extern short	w_open(WWIN *win, short x0, short y0);
extern short	w_move(WWIN *win, short x0, short y0);
extern short	w_close(WWIN *win);
extern short	w_delete(WWIN *win);
extern WFONT	*w_loadfont(char *fontname);
extern short	w_unloadfont(WFONT *font);
extern int w_strlen(WFONT *font, char *s);

/* in button.c */
extern WWIN *w_createButton(WWIN *parent, short x0, short y0, short width, short height);
extern short w_showButton(WWIN *button);
extern short w_hideButton(WWIN *button);

extern WEVENT	*w_queryevent(fd_set *rdp, fd_set *wdp, fd_set *xdp, long timeout);

extern short	w_querywinsize(WWIN *win, short effective, short *width, short *height);
extern short	w_settitle(WWIN *win, char *s);
extern short	w_setmode(WWIN *win, short mode);
extern short	w_plot(WWIN *win, short x0, short y0);
extern short	w_dplot(WWIN *win, short x0, short y0);
extern short	w_test(WWIN *win, short x0, short y0);
extern short	w_line(WWIN *win, short x0, short y0, short xe, short ye);
extern short	w_dline(WWIN *win, short x0, short y0, short xe, short ye);
extern short	w_hline(WWIN *win, short x0, short y0, short xe);
extern short	w_dhline(WWIN *win, short x0, short y0, short xe);
extern short	w_vline(WWIN *win, short x0, short y0, short ye);
extern short	w_dvline(WWIN *win, short x0, short y0, short ye);
extern short	w_box(WWIN *win, short x0, short y0, short width, short height);
extern short	w_dbox(WWIN *win, short x0, short y0, short width, short height);
extern short	w_pbox(WWIN *win, short x0, short y0, short width, short height);
extern short	w_dpbox(WWIN *win, short x0, short y0, short width, short height);
extern short	w_bitblk(WWIN *win, short x0, short y0, short width, short height, short x1, short y1);
extern short	w_bitblk2(WWIN *swin, short x0, short y0, short width, short height, WWIN *dwin, short x1, short y1);
extern short	w_vscroll(WWIN *win, short x0, short y0, short width, short height, short y1);
extern WFONT	*w_setfont(WWIN *win, WFONT *font);
extern short	w_settextstyle(WWIN *win, short flags);
extern short	w_printchar(WWIN *win, short x0, short y0, short c);
extern short	w_printstring(WWIN *win, short x0, short y0, char *s);
extern short	w_centerPrints(WWIN *win, WFONT *font, char *s);
extern short	w_querymousepos(WWIN *win, short *x0, short *y0);
extern short	w_querywindowpos(WWIN *win, short effective, short *x0, short *y0);
extern BITMAP	*w_getblock(WWIN *win, short x0, short y0, short width, short height);
extern short	w_putblock(BITMAP *bm, short x0, short y0, short width, short height, WWIN *win, short x1, short y1);
extern short	w_circle(WWIN *win, short x0, short y0, short r);
extern short	w_dcircle(WWIN *win, short x0, short y0, short r);
extern short	w_pcircle(WWIN *win, short x0, short y0, short r);
extern short	w_dpcircle(WWIN *win, short x0, short y0, short r);
extern short	w_querystatus(STATUS *st, short index);
extern ushort	w_setpattern(WWIN *win, ushort pattern);
extern short	w_poly(WWIN *win, short numpoints, short *points);
extern short	w_dpoly(WWIN *win, short numpoints, short *points);
extern short	w_ppoly(WWIN *win, short numpoints, short *points);
extern short	w_dppoly(WWIN *win, short numpoints, short *points);
extern short	w_setsaver(short seconds);
extern short	w_null(void);
extern void	w_flush(void);
extern short	w_beep(void);
extern void	w_trace(short flag);
extern BITMAP	*w_readimg(char *fname, short *width, short *height);

extern void	scan_geometry(char *geometry, short *col, short *lin, short *xp, short *yp);
