# hints/mint.sh
#
# talk to gufl0000@stud.uni-sb.de if you want to change this file.
# Please read the README section at the end of this file.
#
# misc stuff
test "`uname -m`" = "ataritt" && archname='m68k-mint' || archname='m68000-mint'
cc='gcc'
ccflags='-D__MINT__ -Uatarist -DDEBUGGING'

# libs

libpth="$prefix/lib /usr/lib /usr/local/lib /usr/local/lib/gcc-lib/m68k-mint/`gcc --version`"
glibpth="$libpth"
xlibpth="$libpth"

libswanted='gdbm socket port m'
so='none'

#
# compiler & linker flags
#
optimize='-O3 -fomit-frame-pointer -fno-defer-pop -fstrength-reduce'

# The setlocale function in the MiNTLib is actually a bad joke.  We 
# lend a workaround from Ultrix.  If neither LC_ALL nor LANG is
# set in the environment, perl won't complain.  If one is set to
# anything but "C" you will see a warning.  Note that you can
# still use the GNU extension "$LANGUAGE" if you want to use
# the i18n features of some GNU packages.
util_cflags='ccflags="$ccflags -DLOCALE_ENVIRON_REQUIRED"'

#
# Some good answers to the questionf in Configure:
usenm='true'
d_suidsafe='true'
clocktype='long'
usevfork='true'
d_fsetpos='fpos_t'
gidtype='gid_t'
groupstype='gid_t'
lseektype='long'
models='none'
modetype='mode_t'
sizetype='size_t'
timetype='time_t'
uidtype='uid_t'

##########################################################################
# *** README ***
##########################################################################
# If you want to build perl yourself on MiNT (or maybe on an Atari without
# MiNT) you might accept some advice from somebody who already did it...
# 
# There was a perl port for Atari ST done by ++jrb bammi@cadence.com.
# This port tried very hard to build on non-MiNT-systems.  For the
# sake of efficiency I've left this way.  Yet, I haven't removed bammi's
# patches but left them intact.  Unfortunately some of the files that
# bammi contributed to the perl distribution seem to have vanished?
#
# So, how can you distinguish my patches and bammi's patches?  All of
# bammi's stuff is embedded in "#ifdef atarist" preprocessor macros.
# My MiNT port uses "#ifdef __MINT__" instead (and unconditionally
# undefines "atarist".  If you want to continue on bammi's port, all 
# you have to do is to swap the "-D" and "-U" switches for "__MINT__"  
# and "atarist" in the variable ccflags.
#
# However, I think that my version will still run on non-MiNT-systems
# provided that the user has a Eunuchs-like environment (i.e. the
# standard envariables like $PATH, $HOME, ... are set, there is a
# POSIX compliant shell in /bin/sh, and...)
#
# This version of perl has passed most of the tests on my system:
# Failed Test  Status Wstat Total Fail  Failed  List of failed
# ------------------------------------------------------------------------------
# io/pipe.t                    10    2  20.00%  7, 9
# io/tell.t                    13    1   7.69%  12
# lib/complex.t               762   13   1.71%  84-85, 248-251, 257, 272-273, 
#                                               371, 380, 419-420
# lib/io_pipe.t                10    1  10.00%  9
# lib/io_tell.t                13    1   7.69%  12
# lib/sdbm.t       33  8448    ??   ??       %  ??
# op/magic.t                   30    2   6.67%  29-30
# op/stat.t                    56    1   1.79%  2
# Failed 8/152 test scripts, 94.74% okay. 21/4341 subtests failed, 99.52% okay.
#
# Pipes always cause problems with MiNT, it's actually a surprise that
# most of the tests did work.  I've got no idea why the "tell" test failed,
# usually this should mean too big a problem however.
#
# Most of the failures of lib/complex seem to be harmless, actually errors
# far right to the decimal point...  Two failures seem to be serious:
# The sign of the results is reversed.  I would say that this is due
# to minor bugs in the portable math lib that I compiled perl with.
#
# The sdbm tests failed because MiNT lacks of a dynamic linker.  I don't
# know why there is no possibility to use a statically linked version
# of sdbm.  Maybe I did something wrong during the build process.
# Next time...
#
# I haven't bothered very much to find the reason for the failures
# with op/magic.t and op/stat.t.  Maybe you'll find it out.
#
##########################################################################
# 
# Another problem might occur depending on your linker.  If it's the
# old one it will expect library names of the form "<mod><name>.olb" 
# instead of the standard "lib<mod><name>.a" where <mod> is a modifier
# like "b" for baserel and so on.  Unfortunately the Configure script
# cannot handle the olb-format.  To avoid problems you should create
# symbolic links from your olb-libs to the .a-libs.
#
# The next problem I had was my implementation of the "pwd" command.
# It happened to add a carriage return and newline to its output no matter 
# what the setting of $UNIXMODE is.  This is quite annoying since many
# library modules for perl take the output of pwd, chop off the
# trailing newline character and then expect to see a valid path in
# that.  But the carriage return (last but second character!) isn't
# chopped off.  You can either try to patch all library modules (at
# the price of performance for the extra transformation) or you can
# use my version of pwd that doesn't suffer from this deficiency:
# 
# /* pwd.c - replacement for broken pwd command.
#  * Copyleft 1997 Guido Flohr, <gufl0000@stud.uni-sb.de>.
#  * Do with it as you please.
#  */
# #include <stdio.h>
# #include <limits.h>
# #include <unistd.h>
# #include <string.h>
# #include <errno.h>
#
# #if defined(__STDC__) || defined(__cplusplus)
# int main (int argc, char* argv[])
# #else
# int main (argc, argv)
# 	int argc;
# 	char* argv[];
# #endif
# {
# 	char path_buf[PATH_MAX + 1];
# 	
# 	if (argc > 1) {
# 		int i;
# 		
# 		fflush (stdout);
# 		fputs (argv[0], stderr);
# 		fputs (": ignoring garbage arguments\n", stderr);
# 	}
# 	
# 	if (!getcwd (path_buf, PATH_MAX + 1)) {
# 		fflush (stdout);
# 		fputs (argv[0], stderr);
# 		fputs (": can\'t get current working directory: ", stderr);
# 		fputs (strerror (errno), stderr);
# 		fputc ('\n', stderr);
# 		return 1;
# 	}
# 	if (puts (path_buf) < 0) {
# 		return 1;
# 	}
# 	return 0;
# }
# /* End of pwd.c.  */
#
# Remove the leading "# " from all lines, save it as pwd.c and type into
# your shell:
# 
# 	CFLAGS=-O3 make pwd && cp pwd /usr/bin/pwd
# 
# This is the fastest solution.  Just in case you want to go the
# hard way:  perl won't even build with a broken pwd!  You have
# to fix the library modules at last after building miniperl.
#
# A major nuisance of current MiNTLib versions is the implementation
# of system() which is far from being POSIX compliant.  A real system()
# should fork and then exec /bin/sh with its argument as a command
# line to the shell.  The MiNTLib system() however doesn't expect
# that every user has a POSIX shell in /bin/sh.  It tries to work
# around the problem by forking and exec'ing the first token in its argument
# string.  To get a little bit of compliance to POSIX system() it
# tries to handle at least redirection ("<" or ">") on its own 
# behalf.  
# This isn't a good idea since many programs expect that they can
# pass a command line to system() that exploits all features of a
# POSIX shell.  If you use the MiNTLib version of system() with
# perl the Perl function system() will suffer from the same deficiencies.
# 
# If you don't like that, send me an e-mail (gufl0000@stud.uni-sb.de).
# I can provide you a more or less POSIX compliant system() that
# you can compile into your libc.  This will fix the problem.  "My"
# system() is actually based on system() in the GNU libc.  It
# first checks permission rights for "/bin/sh".  If this fails it
# reads the environment variable $SHELL to find a POSIX shell.  On
# success it will use the GNU version of system().  Only
# in case it can't find any shell it will fall back into the
# MiNTLib behavior.
#
# Anything missing?  Yep, I've almost forgotten...  
# No file in this  distribution without a fine saying.  Take this
# one:
#
#	"From a thief you should learn: (1) to work at night;
#	(2) if one cannot gain what one wants in one night to
#	try again the next night; (3) to love one's coworkers
#	just as thieves love each other; (4) to be willing to
#	risk one's life even for a little thing; (5) not to 
#	attach too much value to things even though one has 
#	risked one's life for them - just as a thief will resell
#	a stolen article for a fraction of its real value; 
#	(6) to withstand all kinds of beatings and tortures
#	but to remain what you are; and (7) to believe your
#	work is worthwhile and not be willing to change it."
#
#			-- Rabbi Dov Baer, Maggid of Mezeritch
#
# OK, this was my motto while working on Perl for MiNT, especially
# rule (1)...
#
# Have fun with Perl1
#
# Guido Flohr
# --
# mailto:gufl0000@stud.uni-sb.de
# http://stud.uni-sb.de/~gufl0000
