#
#  This Makefile is designed to work on the old "make" program.  It does
#  not use the obj subdirectory.  It also does not install documentation
#  automatically -- think of it as a quick start for sites that have the
#  old make program (I recommend that you get and port the new make if you
#  are going to be doing any signficant work on sendmail).
#
#	@(#)Makefile.dist	8.2 (Berkeley) 11/27/93
#

# use O=-O (usual) or O=-g (debugging)
O=	-O2 -g

# location of sendmail source directory
SRCDIR=	../src

# define the database mechanisms available for map & alias lookups:
#	-DNDBM -- use new DBM
#	-DNEWDB -- use new Berkeley DB
# The really old (V7) DBM library is no longer supported.
#
DBMDEF=	-DNDBM -DNEWDB

# environment definitions (e.g., -D_AIX3)
ENVDEF=

# see also conf.h for additional compilation flags

# include directories
INCDIRS=-I${SRCDIR}

# loader options
LDOPTS=

# library directories
LIBDIRS=

# libraries required on your system
LIBS=	-ldb -lgdbm -lsocket -liio -lportlib

# location of mailstats binary (usually /usr/sbin or /usr/etc)
BINDIR=	${DESTDIR}/usr/sbin

# additional .o files needed
OBJADD=

###################  end of user configuration flags  ######################

CFLAGS=	-I. $O ${INCDIRS} ${DBMDEF} ${ENVDEF}

OBJS=	mailstats.o ${OBJADD}

LINKS=	/bin/newaliases /bin/mailq
BINOWN=	bin
BINGRP=	bin
BINMODE=555

ALL=	mailstats

all: ${ALL}

mailstats: ${BEFORE} ${OBJS}
	${CC} -o $@ ${LDOPTS} ${OBJS} ${LIBDIRS} ${LIBS} -G
	strip -k $@
	fixstk 16K $@
	chmod a+x $@
	${CC} -o $@.sym ${LDOPTS} ${OBJS} ${LIBDIRS} ${LIBS} -B/sym-

install: install-mailstats

install-mailstats: mailstats
	install -o ${BINOWN} -g ${BINGRP} -m ${BINMODE} mailstats ${BINDIR}

clean:
	rm -f ${OBJS} mailstats

# dependencies
#   gross overkill, and yet still not quite enough....
${OBJS}: ${SRCDIR}/conf.h
