#include <stdarg.h>
#include <stdio.h>
#include <limits.h>

extern int _doprnt (int (*f) (int, FILE *), FILE *, const char *, va_list);
static int snputc  (int ch, FILE *fp);

struct sinfo {
	char *bufp;
	long size;
	long max;
};

static int
snputc (ch, fp)
     int ch;
     FILE *fp;
{
	struct sinfo *sip = (struct sinfo *)fp;

	if (sip->size >= sip->max)
		return EOF;
	++sip->size;
	*(sip->bufp)++ = ch;
	return ((int)ch) & 0xff;
}

#ifdef __STDC__
int snprintf(char *buf, int len, const char *fmt, ...)
#else
int snprintf(buf, len, fmt)
	char *buf;
	int len;
	const char *fmt;
#endif
{
	register int n;
	va_list argp;
	struct sinfo si;

	si.bufp = buf;
	si.size = 0;
	si.max  = len-1;

	va_start(argp, fmt);
	n = _doprnt(snputc, (FILE *)&si, fmt, argp);
	if (si.size < si.max)
		*(si.bufp) = '\0';		/* always tie of the string */
	return(n);
}
