/*
 * Copyright 1993, 1994 by Ulrich Khn. All rights reserved.
 *
 * THIS PROGRAM COMES WITH ABSOLUTELY NO WARRANTY, NOT
 * EVEN THE IMPLIED WARRANTIES OF MERCHANTIBILITY OR
 * FITNESS FOR A PARTICULAR PURPOSE. USE AT YOUR OWN
 * RISK.
 */

/*
 * File : auth.h
 *        client authorization
 */

#ifndef AUTH_H
#define AUTH_H

#include <types.h>
#include "mount.h"


typedef struct options
{
	int read_only;    /* export is read-only */
	int root_access;  /* root access allowed */
	/* more to come later */
} options;


typedef struct client_info
{
	struct client_info *next;
	char *name;
	char *mountpoint;
	options opt;
} client_info;


extern exportlist *exports;
extern client_info *clients;
extern client_info *unknown_clients;


int auth_init();


#endif
