/*
 *	Skeleton for the info devices (/dev/unix, /dev/route, ...)
 *
 *	02/28/94, kay roemer.
 */

#include "config.h"
#include "kerbind.h"
#include "file.h"
#include "atarierr.h"
#include "util.h"

long
dummydev_init (name, descr)
	char *name;
	struct dev_descr *descr;
{
	char message[200];
	long r;

	r = d_cntl (DEV_INSTALL, name, descr);
	if (!r || r == EINVFN) {
		sprintf (message, "Cannot install device %s\r\n", name);
		c_conws (message);
		return -1;
	}
	return 0;
}	

long
dummydev_open (fp)
	FILEPTR *fp;
{
	/* Nothing to do */
	return 0;
}

long
dummydev_write (fp, buf, nbytes)
	FILEPTR *fp;
	char *buf;
	long nbytes;
{
	return EACCDN;
}

long
dummydev_lseek (fp, where, whence)
	FILEPTR *fp;
	long where;
	short whence;
{
	switch (whence) {
	case SEEK_SET:
		fp->pos = where;
		return fp->pos;
		
	case SEEK_CUR:
		fp->pos += where;
		return fp->pos;
		
	case SEEK_END:
		return EACCDN;
	}
	return EINVFN;
}

long
dummydev_ioctl (fp, mode, buf)
	FILEPTR *fp;
	short mode;
	void *buf;
{
	switch (mode) {
	case FIONREAD:
		*(long *)buf = NO_LIMIT;
		return 0;

	case FIONWRITE:
		*(long *)buf = NO_LIMIT;
		return 0;

	default:
		return EINVFN;
	}
}

long
dummydev_datime (fp, timeptr, rwflag)
	FILEPTR *fp;
	short *timeptr;
	short rwflag;
{
	if (!rwflag) {
		timeptr[0] = t_gettime ();
		timeptr[1] = t_getdate ();
	}
	return 0;
}

long
dummydev_close (fp, pid)
	FILEPTR *fp;
	short pid;
{
	/* Nothing to do */
	return 0;
}

long
dummydev_select (fp, proc, mode)
	FILEPTR *fp;
	long proc;
	short mode;
{
	return 1;
}

void
dummydev_unselect (fp, proc, mode)
	FILEPTR *fp;
	long proc;
	short mode;
{
	/* Nothing to do */
}
