#ifndef _TIMER_H
#define _TIMER_H

#define EVTGRAN		10	/* timer granularity in ms */
#define GETTIME()	(*(volatile long *)0x4baL)
#define DIFTIME(o,n)	(((n) - (o))/(EVTGRAN/5))

struct event {
	long		delta;
	void		(*func) (long);
	long		arg;
	struct event	*next;
};

#ifndef NOEXTERNS
extern void	event_del	(struct event *);
extern long	event_delta	(struct event *);
extern void	event_reset	(struct event *, long);
extern void	event_add	(struct event *, long, void (*) (long), long);
#endif

#endif /* _TIMER_H */
