#!/bin/sh
#
# MintNet install script, (w) 1995 Kay Roemer.
# 

#
# defaults.
#
IPADDRESS=192.168.2.15
HOSTNAME=nowhere
DOMAINNAME=nirwana.org
NAMESERVER=

INCDIR=/usr/include
if test $GNUINC; then INCDIR=$GNUINC; fi

LIBDIR=/usr/lib
if test $GNULIB; then LIBDIR=$GNULIB; fi

ETCDIR=/etc
USRETCDIR=/usr/etc

MINTDIR=/c/mint
if test -d /c/multitos; then MINTDIR=/c/multitos; fi

BOOTDIR=/c

TMPRCNET=/tmp/rcnet$$

TOOLS="ifconfig iflink ifstats route arp netstat slattach pppconf"
CONFS="services protocols networks host.conf"
LIBS_OLD="socket.olb bsocket.olb socket16.olb bsocket16.olb"
LIBS_NEW="libsocket.a blibsocket.a libsocket16.a blibsocket.a"
INCS="sys/socket.h sys/un.h netinet/in.h netinet/in_systm.h netinet/ip.h \
netinet/ip_icmp.h netinet/tcp.h netinet/udp.h arpa/ftp.h arpa/inet.h \
arpa/nameser.h arpa/telnet.h arpa/tftp.h net/if.h net/route.h net/if_arp.h \
net/if_ether.h net/if_sl.h net/if_ppp.h resolv.h netdb.h sockios.h"

INCSUBDIRS="sys netinet arpa net"

#
# What drivers to install per default
#
INSTSLIP=no
INSTPLIP=no
INSTDE600=no

#
# some useful regular expressions.
#
IPREGEXP='\([0-9]\+\.\)\{3,3\}[0-9]\+'
HOSTREGEXP='[a-zA-Z0-9-]\+'
DOMAINREGEXP='\([a-zA-Z0-9-]\+\.\)\{0,\}[a-zA-Z0-9-]\+'
BAUDREGEXP='\(300\)\|\(600\)\|\(1200\)\|\(1800\)\|\(2400\)\|\(4800\)\|\(9600\)\|\(19200\)\|\(38400\)\|\(57600\)\|\(115200\)\|\(153600\)'

#
# The reg expressions are too complicated for test xxx : regexp
#
matchregexp () {
	if test `echo $1 | sed -e "s/$2/ok/"` != ok; then
		return 1
	else
		return 0
	fi
}

myread () {
	local INP
	if read INP; then
		if test ! $INP; then
			eval "$1=\"$2\""
		else
			eval "$1=\"$INP\""
		fi
		return 0
	else
		return 1
	fi
}

yesno () {
	while true; do
		echo -n "$1"
		local ANSWER
		myread ANSWER $2
		case $ANSWER in
		n*)
			return 1
			;;
		y*)
			return 0
			;;
		esac
		echo "Just say yes or no."
		echo
	done	
}

askfor () {
	while true; do
		if test "$3"; then
			echo -n "Please enter the $2 [$3]: "
		else
			echo -n "Please enter the $2: "
		fi
		local INPUT
		myread INPUT $3
		if test $INPUT; then
			if test ! "$4" || matchregexp $INPUT "$4"; then
				if test ! "$5" || eval "$5 $INPUT"; then
					eval "$1=\"$INPUT\""
					echo "Using \"$INPUT\" as $2."
					return 0
				fi
			fi
		fi
		echo "Invalid $2. Try again."
	done
}

netof () {
	local BYTE1=`echo $2 | cut -d. -f1 -`
	if test $BYTE1 -le 127; then
		#
		# class A
		#
		eval "$1=`echo $2 | cut -d. -f1 -`.0.0.0"
	elif test $BYTE1 -le 191; then
		#
		# class B
		#
		eval "$1=`echo $2 | cut -d. -f1-2 -`.0.0"
	elif test $BYTE1 -le 223; then
		#
		# class C
		#
		eval "$1=`echo $2 | cut -d. -f1-3 -`.0"
	else
		eval "$1=$2"
		return 1
	fi
	return 0
}

cleanup () {
	echo; echo; echo "Aborting installation."
	rm -f $TMPRCNET
	exit 0
}

askhostname () {
	echo
	askfor HOSTNAME "host name" $HOSTNAME $HOSTREGEXP
}

askdomainname () {
	echo
	askfor DOMAINNAME "domain name" $DOMAINNAME $DOMAINREGEXP
}

askipaddr () {
	echo
	askfor IPADDRESS "IP address for \"$HOSTNAME\"" $IPADDRESS $IPREGEXP
}

askns () {
	echo
	if yesno "Do you want to use a nameserver [no]: " n; then
		askfor NAMESERVER "name server IP address" $IPADDRESS $IPREGEXP
	else
		echo "Ok, I will use no name server."
	fi
}

askconn () {
	echo
	if yesno "Do you want to setup connections to remote hosts? [yes]: " y; then
	else
		return 0
	fi

	local DEFRTANSW=yes

	echo
	if yesno "Setup a SLIP connection? [no]: " n; then
		local PROTO=slip
		if test -c /dev/ttya; then
			local DEVICE=/dev/ttya
		else
			local DEVICE=/dev/modem1
		fi
		local REMOTEIP
		local SPEED=19200
		local DEFRT=-d
		local MTU=296

		INSTSLIP=yes
		
		if yesno "Use header compression (CSLIP)? [yes]: " y; then
			PROTO=cslip
		fi
		askfor REMOTEIP "IP address of remote host" "" $IPREGEXP
		if yesno "Install default route over the SLIP link? [$DEFRTANSW]: " $DEFRTANSW; then
			DEFRT=
			DEFRTANSW=no
		fi
		askfor MTU "maximum packet size" $MTU '[0-9]\+'
		askfor DEVICE "serial device" $DEVICE "" "test -c"
		askfor SPEED "baud rate" $SPEED $BAUDREGEXP
		cat >> $TMPRCNET <<-EOD
#
# setup SLIP connection
#
$ETCDIR/slattach -l $IPADDRESS -r $REMOTEIP -p $PROTO -s $SPEED -t $DEVICE $DEFRT
$ETCDIR/ifconfig sl0 mtu $MTU

EOD
	fi

	echo
	if yesno "Setup a PLIP connection? [no]: " n; then
		local REMOTEIP
		local DEFRT
		local MTU=2000

		INSTPLIP=yes

		askfor REMOTEIP "IP address of remote host" "" $IPREGEXP
		if yesno "Install default route over the PLIP link? [$DEFRTANSW]: " $DEFRTANSW; then
			DEFRT="$ETCDIR/route add default pl0 gw $REMOTEIP"
			DEFRTANSW=no
		fi
		cat >> $TMPRCNET <<-EOD
#
# setup PLIP connection
#
$ETCDIR/ifconfig pl0 addr $IPADDRESS dstaddr $REMOTEIP mtu $MTU up
$ETCDIR/route add $REMOTEIP pl0
$DEFRT

EOD
	fi

	echo
	if yesno "Setup an Ethernet connection? [no]: " n; then
		local DEFRT
		local NETWORK
		local GATEWAY

		INSTDE600=yes

		netof NETWORK $IPADDRESS
		if yesno "Install default route over the Ethernet link? [$DEFRTANSW]: " $DEFRTANSW; then
			local N1
			while true; do
				echo -n "Please enter the default gateway: "
				myread GATEWAY ""
				if matchregexp $GATEWAY $IPREGEXP; then
				else
					echo "\"$GATEWAY\" is no valid IP address. Try again."
					continue
				fi
				netof N1 $GATEWAY
				if test $N1 = $NETWORK; then
					echo "Using \"$GATEWAY\" as gateway IP address."
					DEFRT="$ETCDIR/route add default en0 gw $GATEWAY"
					DEFRTANSW=no
					break
				fi
				echo "The gateway IP address must be on network $NETWORK, ie. the"
				echo "same network your hosts IP address is on. The IP address you"
				echo "just entered is not on this network. Try again."
				echo
			done
		fi
		cat >> $TMPRCNET <<-EOD
#
# setup Ethernet connection
#
$ETCDIR/ifconfig en0 addr $IPADDRESS
$ETCDIR/route add $NETWORK en0
$DEFRT

EOD
	fi
}

instlib () {
	echo
	if yesno "Do you want to install library include files? [yes]: " y; then
		while true; do
			echo -n "Where shall I install the includes? [$INCDIR]: "
			local NEWINCDIR
			myread NEWINCDIR $INCDIR
			if test -d $NEWINCDIR; then
				INCDIR=$NEWINCDIR
				break
			fi
			echo "\"$NEWINCDIR\" does not exist or is no directory. Try again."
			echo
		done
		echo "Making subdirs in $INCDIR:"
		for i in `echo $INCSUBDIRS`; do
			if test ! -e $INCDIR/$i; then
				echo -n "$i "
				mkdir $INCDIR/$i
			fi
		done
		echo .
		echo "Installing includes in $INCDIR:"
		for i in `echo $INCS`; do
			echo -n "$i "
			install -m 644 lib/$i $INCDIR/$i
		done
		echo .
	fi

	echo
	if yesno "Do you want to install the libraries? [yes]: " y; then
		while true; do
			echo -n "Where shall I install the libraries? [$LIBDIR]: "
			local NEWLIBDIR
			myread NEWLIBDIR $LIBDIR
			if test -d $NEWLIBDIR; then
				LIBDIR=$NEWLIBDIR
				break
			fi
			echo "\"$NEWLIBDIR\" does not exist or is no directory. Try again."
			echo
		done
		local LIBS="$LIBS_OLD"
		if test -f $LIBDIR/libc.a; then
			echo
			echo "You appear to use lib*.a instead of *.olb style library names."
			if yesno "Install the libs using lib*.a naming style? [yes]: " y; then
				local LIBS="$LIBS_NEW"
			fi
		fi
		echo "Installing libraries in $LIBDIR:"
		for i in `echo $LIBS`; do
			echo -n "$i "
			install -m 644 lib/$i $LIBDIR/$i
		done
		echo .
	fi
}

insttool () {
	echo
	if yesno "Do you want to install the MintNet tools? [yes]: " y; then
		echo "Installing tools in $USRETCDIR and making links to $ETCDIR:"
		for i in `echo $TOOLS`; do
			echo -n "$i "
			install -m 755 tool/$i $USRETCDIR/$i
			ln -fs $USRETCDIR/$i $ETCDIR/$i
		done
		echo .
	fi
}

instconf () {
	echo
	if yesno "Do you want to install the config files? [yes]: " y; then
		echo "Installing config files in $ETCDIR:"
		for i in `echo $CONFS`; do
			echo -n "$i "
			install -m 644 etc/$i $ETCDIR/$i
		done

		echo -n "resolv.conf "
		echo "domain $DOMAINNAME" > $ETCDIR/resolv.conf
		if test $NAMESERVER; then
			echo "nameserver $NAMESERVER" >> $ETCDIR/resolv.conf
		fi

		echo -n "hosts "
		cat > $ETCDIR/hosts <<-EOD
#
# /etc/hosts -- Host database for Mint-Net (w) 1994, Kay Roemer.
#
# The form for each entry is:
# <internet address>	<official hostname> <aliases>
#

127.0.0.1	localhost	loopback
$IPADDRESS	$HOSTNAME	$HOSTNAME.$DOMAINNAME
EOD

		echo -n "hostname "
		echo $HOSTNAME > $ETCDIR/hostname

		echo -n "domainname "
		echo $DOMAINNAME > $ETCDIR/domainname

		echo -n "rc.net "
		cat > $ETCDIR/rc.net <<-EOD
#!/bin/sh
#
# MintNet startup script. Automagically generated by install.sh.
#

#
# Setup loopback interface
#
$ETCDIR/ifconfig lo0 addr 127.0.0.1 up

EOD

		cat $TMPRCNET >> $ETCDIR/rc.net
		cat >> $ETCDIR/rc.net <<-EOD
#
# Start network daemons
#

echo -n "Starting network daemons: "

if [ -f /etc/portmap ] ; then
	echo -n "portmap, "
	/etc/portmap
fi

if [ -f /etc/inetd ] ; then
	echo -n "inetd, "
	/etc/inetd
fi

EOD

		echo .
	fi
}

instdriv () {
	echo
	if yesno "Do you want to install the MintNet drivers? [yes]: " y; then
		while true; do
			echo -n "Where shall I install the drivers? [$MINTDIR]: "
			local NEWMINTDIR
			myread NEWMINTDIR $MINTDIR
			if test -d $NEWMINTDIR; then
				MINTDIR=$NEWMINTDIR
				break
			fi
			echo "\"$NEWMINTDIR\" does not exist or is no directory. Try again."
		done
		echo "Installing sockdev.xdd in $MINTDIR."
		install -m 755 net/sockdev.xdd $MINTDIR/sockdev.xdd

		if yesno "Do you want to install the SLIP/PPP driver [$INSTSLIP]: " $INSTSLIP; then
			echo "Installing slip.xif in $MINTDIR."
			install -m 755 net/drivers/slip.xif $MINTDIR/slip.xif
		fi
		if yesno "Do you want to install the PLIP driver [$INSTPLIP]: " $INSTPLIP; then
			echo "Installing plip.xif in $MINTDIR."
			install -m 755 net/drivers/plip.xif $MINTDIR/plip.xif
		fi
		if yesno "Do you want to install the DE600 driver [$INSTDE600]: " $INSTDE600; then
			echo "Installing de600.xif in $MINTDIR."
			install -m 755 net/drivers/de600.xif $MINTDIR/de600.xif
		fi
		if yesno "Do you want to install the driver for PAMs external DMA adaptor [$INSTDE600]: " $INSTDE600; then
			echo "Installing lancedma.xif in $MINTDIR."
			install -m 755 net/drivers/lancedma.xif $MINTDIR/lancedma.xif
		fi
		if yesno "Do you want to install the LANCE driver (for PAMs EMEGA and TT-VME cards) [$INSTDE600]: " $INSTDE600; then
			echo "Installing lance.xif in $MINTDIR."
			install -m 755 net/drivers/lance.xif $MINTDIR/lance.xif
		fi
	fi
}

instacc () {
	echo
	if yesno "Install nohog.acc? [yes]: " y; then
		while true; do
			echo -n "Where shall I install it? [$BOOTDIR]: "
			local NEWBOOTDIR
			myread NEWBOOTDIR
			if test -d $NEWBOOTDIR; then
				BOOTDIR=$NEWBOOTDIR
				break
			fi
			echo "\"$NEWBOOTDIR\" does not exist or is no directory. Try again."
		done
		echo "Installing nohog.acc in $BOOTDIR."
		install -m 755 nohog.acc $BOOTDIR/nohog.acc
	fi
}

#
# main ()
#
trap cleanup 2 15
cat /dev/null > $TMPRCNET

cat <<-EOD

# This script will install MintNet, ie the device driver, packet drivers,
# utilities, some configuration files and the library.
#
# There is also a section to setup SLIP, PLIP or Ethernet connections
# to directly connected machines. To setup a PPP or SLIP connection that
# goes over a modem and/or needs login chats you will have to install pppd/chat
# for PPP) or dip (for SLIP).
#
# You will be asked quite a lot of questions concerning your network
# environment. If you do not (yet) know the answer you can
# abort the installation process at any time by typing Control-C (followed
# by RETURN).

EOD

#
# ask for config
#
while true; do
	askhostname
	askipaddr
	askdomainname
	askns

	if test $NAMESERVER; then
		PRINTNS=$NAMESERVER
	else
		PRINTNS="(none)"
	fi

	cat <<-EOD

                 Hostname: $HOSTNAME
               Domainname: $DOMAINNAME
Full Qualified Domainname: $HOSTNAME.$DOMAINNAME
          Your IP address: $IPADDRESS
    Nameserver IP address: $PRINTNS

EOD
	if yesno "Are these settings correct? [y]: " y; then
		break
	fi
done

#
# ask for connections to other hosts
#

cat <<-EOD

# setup connections to remote hosts:
#
# This sections allows you to setup network connections to directly connected
# hosts using either (C)SLIP, PLIP or Ethernet. This does NOT work if
# you have to log into the remote host first or have to use a modem to connect
# to the remote host.
#
# In the latter case or to set up a PPP connection you will have to do some
# hand crafting. Good luck!
#
# You will be asked for the IP address of the remote host, ie. the computer
# on the other side of the link. Another important parameter is the maximum
# packet size for the link. This must be the same on both sides of the link!
#
# You will be asked whether to install a so called default route over a
# network connection. The remote host (or gateway) of this connection will
# then be used to forward packets to not directly connected networks.
# Install a default route for EXACTLY one network connection! 

EOD

askconn

#
# install libraries/includes, config files, tools, drivers
#

cat <<-EOD

# Libraries and include files:
#
# The libraries and include files are needed to compile programs that use
# MintNet using the Gnu C compiler. They are not needed to run MintNet and
# accompanied programs.
#
# Anyway, it is recommended to install them. You will be asked for the paths
# where your C compiler libraries and include files are held.

EOD

instlib

cat <<-EOD

# Configuration files:
# 
# The configuration files are necessary to run programs that use MintNet. 
# Those files will be held in $ETCDIR. You must install them.
#
# One special file is $ETCDIR/rc.net, a shell script that must be run every 
# time your system is restarted.

EOD

instconf

cat <<-EOD

# MintNet tool programs:
#
# The tools that come with MintNet are necessary to configure and monitor
# the network interfaces and MintNet as a whole. You must install them.
#
# The tools will be installed in $USRETCDIR and symbolic links will be made
# to $ETCDIR.

EOD

insttool

cat <<-EOD

# MintNet drivers:
#
# The heart of MintNet are the device driver sockdev.xdd and the packet drivers
# *.xif. The device driver must be installed, packet drivers must be installed
# for every comm hardware (Ethernet, SLIP, ...) you want to use. You will be
# asked which packet drivers should be installed.
#
# The default answers for the packet drivers you MUST install (because you
# have set up connections which need them) are 'yes', for all the others
# 'no' is the default answer.
#
# You will be asked for the directory where to install the drivers. This must
# either be called 'mint' or 'multitos' on your boot driver, eg. usually 
# '/c/mint' or '/c/multitos' if C is your boot drive.

EOD

instdriv

cat <<-EOD

# nohog.acc:
#
# This small accessory is necessary if you are going to use Mintnet in
# conjunction with SingleAES. In fact it is needed if you run SingleAES
# on top of Mint. It is strongly recommended to install it.
#
# You will be asked for a path where nohog.acc should be installed. This
# should be your boot drive, ie. usually /c if C is your boot drive. 

EOD

instacc

cat <<-EOD

# The MintNet installation is now finished. Reboot your system now and watch
# for the messages MintNet prints at startup. If you don't see any MintNet
# related messages appear at bootup, then you have specified the wrong
# directory for the MintNet driver.
#
# After successful reboot make sure the shell script $ETCDIR/rc.net is
# executed.
#
# Setup networking on the remote machines if you haven't already done so.
#
# Now you can test whether MintNet works by saying 'ping localhost' and
# 'ping <remote IP address>'. If that works you can go on and install
# additional networking programs. 

EOD

rm -f $TMPRCNET
exit 0
