/*
 * This file has been modified as part of the FreeMiNT project. See
 * the file Changes.MH for details and dates.
 */

/*
 * Copyright 1991,1992 Eric R. Smith.
 * Copyright 1992,1993,1994 Atari Corporation.
 * All rights reserved.
 */

# ifndef _TYPES_H
# define _TYPES_H

# ifdef __TURBOC__
# include "include\misc.h"
# else
# include "misc.h"
# endif


# ifndef LLONG
# define LLONG
typedef struct { long hi; unsigned long lo; } llong;
# endif

typedef unsigned long 	ulong;
typedef unsigned short	ushort;
typedef unsigned char	uchar;

typedef long ARGS_ON_STACK (*Func)();


/* structure used to hold i/o buffers */
typedef struct io_rec
{
	char *bufaddr;
	short buflen;
	volatile short head;
	volatile short tail;
	short low_water;
	short hi_water;
	
} IOREC_T;

/* Bconmap struct, * returned by Bconmap (-2) */
typedef struct
{
	struct
	{
		long bconstat;
		long bconin;
		long bcostat;
		long bconout;
		long rsconf;
		IOREC_T	*iorec;
		
	} *maptab;
	short	maptabsize;
	
} BCONMAP2_T;

# endif /* _TYPES_H */
