/*
 * This file belongs to FreeMiNT.  It's not in the original MiNT 1.12
 * distribution.  See the file Changes.MH for a detailed log of changes.
 */

/*
 * This file is dedicated to the FreeMiNT project.
 * It's not allowed to use this file for other projects without my
 * explicit permission.
 */

/*
 * begin:	1998-07
 * last change: 1998-07-16
 * 
 * Author: Frank Naumann
 * 
 * fnaumann@cs.uni-magdeburg.de
 * Frank Naumann @ L2
 * 
 * please send suggestions, patches or bug reports to me or the MiNT mailing list
 * 
 */

# ifndef _FSTRING_H
# define _FSTRING_H

# ifdef __TURBOC__
# include "include\misc.h"
# include "include\default.h"
# else
# include "misc.h"
# include "default.h"
# endif


# ifdef OWN_LIB

# ifdef __TURBOC__
# include "include\kctype.h"
# else
# include "kctype.h"
# endif

/*
 * Sigh. Some compilers are too clever for their
 * own good; gcc 2.1 now makes strcpy() and some
 * other string functions built-in; the built-in
 * definitions disagree with ours. So we redefine
 * them here. This also helps us to avoid conflict
 * with any library stuff, in the event that we
 * have to link in a library.
 */

# define strlen		MS_len		/* util.c */
# define strcpy		MS_cpy		/* util.c */
# define strncpy	MS_ncpy		/* util.c */
# define strcat		MS_cat		/* util.c */
# define strncat	MS_ncat		/* ??? (not used) */
# define strcmp		MS_cmp		/* util.c */
# define strncmp	MS_ncmp		/* util.c */
# define strnicmp	MS_nicmp	/* util.c */
# define stricmp	MS_icmp		/* util.c */
# define strlwr		MS_lwr		/* util.c */
# define strupr		MS_upr		/* util.c */
# define sleep		M_sleep		/* proc.c */
# define memcpy		quickmovb	/* quickmov.spp */

# else

# include <ctype.h>
# include <string.h>

# endif /* OWN_LIB */


/*
 * fast string functions
 * (for use in time critical parts)
 */

# ifdef OWN_LIB
# define _TOUPPER(c)		fstring_toupper	(c)
# define _TOLOWER(c)		fstring_tolower	(c)
# else
# define _TOUPPER(c)		toupper		(c)
# define _TOLOWER(c)		tolower		(c)
# endif

# define _STRLEN(s)		fstring_strlen	(s)
# define _STRCPY(d, s)		fstring_strcpy	(d, s)
# define _STRNCPY(d, s, l)	fstring_strncpy	(d, s, l)
# define _STRCMP(s1, s2)	fstring_strcmp	(s1, s2)
# define _STRICMP(s1, s2)	fstring_stricmp	(s1, s2)
# define _STRNCMP(s1, s2, l)	fstring_strncmp	(s1, s2, l)
# define _STRNICMP(s1, s2, l)	fstring_strnicmp(s1, s2, l)
# define _STRLWR(s)		fstring_strlwr	(s)
# define _STRUPR(s)		fstring_strupr	(s)

# ifdef USE_INLINE_FUNCS

FASTFN int
fstring_toupper (register int c)
{
	return (islower (c) ? _toupper (c) : c);
}

FASTFN int
fstring_tolower (register int c)
{
	return (isupper (c) ? _tolower (c) : c);
}

FASTFN long
fstring_strlen (register const char *scan)
{
	register const char *start = scan + 1;
	
	while (*scan++) ;
	
	return ((long) (scan - start));
}

FASTFN char *
fstring_strcpy (register char *dst, register const char *src)
{
	register char *_dst = dst;
	
	while ((*_dst++ = *src++) != 0) ;
	
	return dst;
}

FASTFN char *
fstring_strncpy (register char *dst, register const char *src, register long len)
{
	register char *_dst = dst;
	
	while (--len >= 0 && (*_dst++ = *src++) != 0) ;
	if (--len >= 0) *_dst++ = 0;
	
	return dst;
}

FASTFN long
fstring_strcmp (register const char *str1, register const char *str2)
{
	register char c1, c2;
	
	do {
		c1 = *str1++;
		c2 = *str2++;
	}
	while (c1 && c1 == c2);
	
	return (c1 - c2);
}

FASTFN long
fstring_stricmp (register const char *str1, register const char *str2)
{
	register char c1, c2;
	
	do {
		c1 = _TOLOWER (*str1); str1++;
		c2 = _TOLOWER (*str2); str2++;
	}
	while (c1 && c1 == c2);
	
	return (c1 - c2);
}

FASTFN long
fstring_strncmp (register const char *str1, register const char *str2, register long len)
{
	register char c1, c2;
	
	do {
		c1 = *str1++;
		c2 = *str2++;
	}
	while (--len >= 0 && c1 && c1 == c2);
	
	if (len < 0)
		return 0;
	
	return (c1 - c2);
}

FASTFN long
fstring_strnicmp (register const char *str1, register const char *str2, register long len)
{
	register char c1, c2;
	
	do {
		c1 = _TOLOWER (*str1); str1++;
		c2 = _TOLOWER (*str2); str2++;
	}
	while (--len >= 0 && c1 && c1 == c2);
	
	if (len < 0 || c1 == c2)
		return 0;
	
	return (c1 - c2);
}

FASTFN char *
fstring_strlwr (register char *s)
{
	register char c;
	register char *old = s;
	
	while ((c = *s) != 0)
	{
		*s++ = _TOLOWER (c);
	}
	
	return old;
}

FASTFN char *
fstring_strupr (register char *s)
{
	register char c;
	register char *old = s;
	
	while ((c = *s) != 0)
	{
		*s++ = _TOUPPER (c);
	}
	
	return old;
}

# else

# define fstring_toupper(c)					\
({								\
	(islower (c) ? ((c) ^ 0x20) : (c));			\
})

# define fstring_tolower(c)					\
({								\
	(isupper (c) ? ((c) ^ 0x20) : (c));			\
})

# define fstring_strlen(s)					\
({								\
	register const char *_i_scan = s;			\
	register const char *_i_start = s + 1;			\
								\
	while (*_i_scan++) ;					\
								\
	((long) (_i_scan - _i_start));				\
})

# define fstring_strcpy(d, s)					\
({								\
	register char *_i_dst = d;				\
	register const char *_i_src = s;			\
								\
	while ((*_i_dst++ = *_i_src++) != 0) ;			\
								\
	(d);							\
})

# define fstring_strncpy(d, s, l)				\
({								\
	register char *_i_dst = d;				\
	register const char *_i_src = s;			\
	register long _i_len = l;				\
								\
	while (--_i_len >= 0 && (*_i_dst++ = *_i_src++) != 0) ;	\
	if (--_i_len >= 0) *_i_dst++ = 0;			\
								\
	(d);							\
})

# define fstring_strcmp(s1, s2)					\
({								\
	register const char *_i_str1 = s1;			\
	register const char *_i_str2 = s2;			\
	register char _i_c1, _i_c2;				\
								\
	do {							\
		_i_c1 = *_i_str1++;				\
		_i_c2 = *_i_str2++;				\
	}							\
	while (_i_c1 && _i_c1 == _i_c2);			\
								\
	(_i_c1 - _i_c2);					\
})

# define fstring_stricmp(s1, s2)				\
({								\
	register const char *_i_str1 = s1;			\
	register const char *_i_str2 = s2;			\
	register char _i_c1, _i_c2;				\
								\
	do {							\
		_i_c1 = *_i_str1++; _i_c1 = _TOLOWER (_i_c1);	\
		_i_c2 = *_i_str2++; _i_c2 = _TOLOWER (_i_c2);	\
	}							\
	while (_i_c1 && _i_c1 == _i_c2);			\
								\
	(_i_c1 - _i_c2);					\
})

# define fstring_strncmp(s1, s2, l)				\
({								\
	register const char *_i_str1 = s1;			\
	register const char *_i_str2 = s2;			\
	register long _i_len = l;				\
	register char _i_c1, _i_c2;				\
								\
	do {							\
		_i_c1 = *_i_str1++;				\
		_i_c2 = *_i_str2++;				\
	}							\
	while (--_i_len >= 0 && _i_c1 && _i_c1 == _i_c2);	\
								\
	if (_i_len < 0)						\
		return 0;					\
								\
	(_i_c1 - _i_c2);					\
})

# define fstring_strnicmp(s1, s2, l)				\
({								\
	register const char *_i_str1 = s1;			\
	register const char *_i_str2 = s2;			\
	register long _i_len = l;				\
	register char _i_c1, _i_c2;				\
								\
	do {							\
		_i_c1 = *_i_str1++; _i_c1 = _TOLOWER (_i_c1);	\
		_i_c2 = *_i_str2++; _i_c2 = _TOLOWER (_i_c2);	\
	}							\
	while (--_i_len >= 0 && _i_c1 && _i_c1 == _i_c2);	\
								\
	if (_i_len < 0 || _i_c1 == _i_c2)			\
		return 0;					\
								\
	(_i_c1 - _i_c2);					\
})

# endif

# endif /* _FSTRING_H */
