/*
 * This file belongs to FreeMiNT.  It's not in the original MiNT 1.12
 * distribution.  See the file Changes.MH for a detailed log of changes.
 */

/*
 * This file is dedicated to the FreeMiNT project.
 * It's not allowed to use this file for other projects without my
 * explicit permission.
 */

/*
 * begin:	1998-06
 * last change: 1998-07-14
 * 
 * Author: Frank Naumann - <fnaumann@cs.uni-magdeburg.de>
 * 
 * please send suggestions, patches or bug reports to me or
 * the MiNT mailing list
 * 
 */

# ifndef _DEFAULT_H
# define _DEFAULT_H

# include "misc.h"


/*
 * prefer inline functions instead makros
 */

# define USE_INLINE_FUNCS


/*
 * configuration modes
 */

# define ASK	-1
# define DISABLE 0
# define ENABLE  1


/*
 * useful makros
 */

# define MAX(a,b)		(a > b ? a : b)
# define MIN(a,b)		(a > b ? b : a)

# ifdef __TURBOC__

/* Inline-Assembler: Intel-WORD <-> Motorola-WORD */
unsigned short SWAP68_W(unsigned short d0) 0xE058; /* ror.w #8,D0 */

/* Inline-Assembler: Intel-LONG <-> Motorola-LONG */
unsigned long rorw_8_d0(unsigned long d0) 0xE058;  /* ror.w #8,D0 */
unsigned long swap_d0(unsigned long d0) 0x4840;    /* swap  D0    */
#define SWAP68_L(d0) rorw_8_d0(swap_d0(rorw_8_d0(d0)))

# elif defined(__GNUC__)

# ifdef USE_INLINE_FUNCS

FASTFN unsigned short
SWAP68_W (register unsigned short v)
{
	__asm__
	(	"rolw #8, %0"
		: "=d" (v)
		: "0" (v), "d" (v)
	);
	return v;
}

FASTFN unsigned long
SWAP68_L (register unsigned long v)
{
	__asm__
	(	"rolw #8, %0;"
		"swap %0;"
		"rolw #8, %0;"
		: "=d" (v)
		: "0" (v), "d" (v)
	);
	return v;
}

# else

# define SWAP68_W(value)			\
({						\
	register unsigned short ret = value;	\
	__asm__					\
	(	"rolw #8, %0"			\
		: "=d" (ret)			\
		: "0" (ret), "d" (ret)		\
	);					\
	ret;					\
})

# define SWAP68_L(value)			\
({						\
	register unsigned long ret = value;	\
	__asm__					\
	(	"rolw #8, %0;"			\
		"swap %0;"			\
		"rolw #8, %0;"			\
		: "=d" (ret)			\
		: "0" (ret), "d" (ret)		\
	);					\
	ret;					\
})

# endif

# else /* !__TURBOC__ && !__GNUC__ */

# error "not defined for your compiler"

# endif /* __TURBOC__ */


# define str(x)		_stringify (x)
# define _stringify(x)	#x


# endif /* _DEFAULT_H */
