/*
 * This file belongs to FreeMiNT.  It's not in the original MiNT 1.12
 * distribution.  See the file Changes.MH for a detailed log of changes.
 */

/*
 * This file is dedicated to the FreeMiNT project.
 * It's not allowed to use this file on other projects without my explicit
 * permission.
 */

/*
 * begin:	1998-07
 * last change: 1998-07-02
 * 
 * Author: Frank Naumann - <fnaumann@cs.uni-magdeburg.de>
 * 
 * please send suggestions, patches or bug reports to me or
 * the MiNT mailing list
 *  
 */

# include "global.h"

# include "version.h"	/* MAJ_VERSION, MIN_VERSION */
# include "bios.h"	/* bios_tab */
# include "dos.h"	/* dos_tab */
# include "filesys.h"	/* changedrv, denyshare, denylock */
# include "memory.h"	/* kmalloc, kfree, umalloc, ufree */
# include "util.h"	/* strnicmp, stricmp, strlwr, strupr, ms_time, unixtim, dostim */
# include "timeout.h"	/* nap, addtimeout, canceltimeout, addroottimeout, cancelroottimeout */
# include "proc.h"	/* sleep, wake, wakeselect, iwake */
# include "signal.h"	/* ikill */
# include "block_IO.h"	/* bio */


# undef DEFAULT_MODE
# define DEFAULT_MODE	(0666)

/*
 * kernel info that is passed to loaded file systems and device drivers
 */

struct kerinfo kernelinfo =
{
	MAJ_VERSION, MIN_VERSION,
	DEFAULT_MODE, 0,
	bios_tab, dos_tab,
	changedrv,
	Trace, Debug, ALERT, FATAL,
	kmalloc, kfree, umalloc, ufree,
	strnicmp, stricmp, strlwr, strupr, ksprintf,
	ms_time, unixtim, dostim,
	nap, sleep, wake, (void ARGS_ON_STACK (*)P_((long))) wakeselect,
	denyshare, denylock,
	addtimeout, canceltimeout,
	addroottimeout, cancelroottimeout,
	ikill, iwake,
	&bio
};

ulong c20ms = 0;
